/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma.persistence;

import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

@LdapEntry
@LdapObjectClass(values={"top", "oxUmaResource"})
public class UmaResource {
    @LdapDN
    private String dn;
    @LdapAttribute(ignoreDuringUpdate=true)
    private String inum;
    @LdapAttribute(name="oxId")
    private String id;
    @NotNull(message="Display name should be not empty")
    @LdapAttribute(name="displayName")
    private String name;
    @LdapAttribute(name="oxFaviconImage")
    private String iconUri;
    @LdapAttribute(name="oxAuthUmaScope")
    private List<String> scopes;
    @LdapAttribute(name="oxScopeExpression")
    private String scopeExpression;
    @LdapAttribute(name="oxAssociatedClient")
    private List<String> clients;
    @LdapAttribute(name="oxResource")
    private List<String> resources;
    @LdapAttribute(name="oxRevision")
    private String rev;
    @LdapAttribute(name="owner")
    private String creator;
    @LdapAttribute(name="description")
    private String description;
    @LdapAttribute(name="oxType")
    private String type;
    @LdapAttribute(name="oxAuthCreation")
    private Date creationDate;
    @LdapAttribute(name="oxAuthExpiration")
    private Date expirationDate;

    public String getScopeExpression() {
        return this.scopeExpression;
    }

    public void setScopeExpression(String scopeExpression) {
        this.scopeExpression = scopeExpression;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getClients() {
        return this.clients;
    }

    public void setClients(List<String> p_clients) {
        this.clients = p_clients;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.expirationDate != null && new Date().after(this.expirationDate);
    }

    public String toString() {
        return "UmaResource{dn='" + this.dn + '\'' + ", inum='" + this.inum + '\'' + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", iconUri='" + this.iconUri + '\'' + ", scopes=" + this.scopes + ", scopeExpression='" + this.scopeExpression + '\'' + ", clients=" + this.clients + ", resources=" + this.resources + ", rev='" + this.rev + '\'' + ", creator='" + this.creator + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + ", creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + '}';
    }
}

