/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.jboss.resteasy.annotations.providers.jaxb.IgnoreMediaTypes;
import org.xdi.oxauth.model.uma.JsonLogicNodeParser;

@IgnoreMediaTypes(value={"application/*+json"})
@JsonPropertyOrder(value={"name", "uri", "type", "scopes", "scopeExpression", "icon_uri"})
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@ApiModel(value="The resource server defines a resource set that the authorization server needs to be aware of by registering a resource set description at the authorization server. This registration process results in a unique identifier for the resource set that the resource server can later use for managing its description.")
public class UmaResource {
    @ApiModelProperty(value="An array of strings, any of which MAY be a URI, indicating the available scopes for this resource set. URIs MUST resolve to scope descriptions as defined in Section 2.1. Published scope descriptions MAY reside anywhere on the web; a resource server is not required to self-host scope descriptions and may wish to point to standardized scope descriptions residing elsewhere. It is the resource server's responsibility to ensure that scope description documents are accessible to authorization servers through GET calls to support any user interface requirements. The resource server and authorization server are presumed to have separately negotiated any required interpretation of scope handling not conveyed through scope descriptions.", required=false)
    private List<String> scopes;
    @ApiModelProperty(value="Scope expression.", required=false)
    private String scopeExpression;
    @ApiModelProperty(value="A human-readable string describing the resource at length. The authorization server MAY use this description in any user interface it presents to a resource owner, for example, for resource protection monitoring or policy setting.", required=false)
    private String description;
    @ApiModelProperty(value="A URI for a graphic icon representing the resource set. The referenced icon MAY be used by the authorization server in its resource owner user interface for the resource owner.", required=false)
    private String iconUri;
    @ApiModelProperty(value=" A human-readable string describing a set of one or more resources. This name MAY be used by the authorization server in its resource owner user interface for the resource owner.", required=false)
    private String name;
    @ApiModelProperty(value=" A string uniquely identifying the semantics of the resource set. For example, if the resource set consists of a single resource that is an identity claim that leverages standardized claim semantics for \"verified email address\", the value of this property could be an identifying URI for this claim.", required=false)
    private String type;
    @ApiModelProperty(value="Integer timestamp, measured in the number of seconds since January 1 1970 UTC, indicating when this resource was originally issued.", required=true)
    private Integer iat;
    @ApiModelProperty(value=" Integer timestamp, measured in the number of seconds since January 1 1970 UTC, indicating when this resource will expire. ", required=true)
    private Integer exp;

    @JsonProperty(value="iat")
    @XmlElement(name="iat")
    public Integer getIat() {
        return this.iat;
    }

    public void setIat(Integer iat) {
        this.iat = iat;
    }

    @JsonProperty(value="exp")
    @XmlElement(name="exp")
    public Integer getExp() {
        return this.exp;
    }

    public void setExp(Integer exp) {
        this.exp = exp;
    }

    @JsonProperty(value="description")
    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="type")
    @XmlElement(name="type")
    public String getType() {
        return this.type;
    }

    public UmaResource setType(String p_type) {
        this.type = p_type;
        return this;
    }

    @JsonProperty(value="name")
    @XmlElement(name="name")
    public String getName() {
        return this.name;
    }

    public UmaResource setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="icon_uri")
    @XmlElement(name="icon_uri")
    public String getIconUri() {
        return this.iconUri;
    }

    public UmaResource setIconUri(String iconUri) {
        this.iconUri = iconUri;
        return this;
    }

    @JsonProperty(value="resource_scopes")
    @XmlElement(name="resource_scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    public UmaResource setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    @JsonProperty(value="scope_expression")
    @XmlElement(name="scope_expression")
    public String getScopeExpression() {
        return this.scopeExpression;
    }

    public void setScopeExpression(String scopeExpression) {
        UmaResource.assertValidExpression(scopeExpression);
        this.scopeExpression = scopeExpression;
    }

    @JsonIgnore
    public static void assertValidExpression(String scopeExpression) {
        if (!UmaResource.isValidExpression(scopeExpression)) {
            throw new RuntimeException("Scope expression is not valid json logic expression. Expression:" + scopeExpression);
        }
    }

    @JsonIgnore
    public static boolean isValidExpression(String scopeExpression) {
        return StringUtils.isBlank(scopeExpression) || JsonLogicNodeParser.isNodeValid(scopeExpression);
    }

    public String toString() {
        return "UmaResource{name='" + this.name + '\'' + ", scopes=" + this.scopes + ", scopeExpression=" + this.scopeExpression + ", description='" + this.description + '\'' + ", iconUri='" + this.iconUri + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

