/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwt;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.util.Base64Util;

public class PureJwt {
    private final String m_encodedHeader;
    private final String m_encodedPayload;
    private final String m_encodedSignature;
    private final String m_signingInput;
    private final String m_decodedHeader;
    private final String m_decodedPayload;

    public PureJwt(String p_encodedHeader, String p_encodedPayload, String p_encodedSignature) {
        this.m_encodedHeader = p_encodedHeader;
        this.m_encodedPayload = p_encodedPayload;
        this.m_encodedSignature = p_encodedSignature;
        this.m_signingInput = this.m_encodedHeader + "." + this.m_encodedPayload;
        String decodedPayloadTemp = null;
        String decodedHeaderTemp = null;
        try {
            decodedHeaderTemp = new String(Base64Util.base64urldecode(p_encodedHeader), "UTF-8");
            decodedPayloadTemp = new String(Base64Util.base64urldecode(p_encodedPayload), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.m_decodedHeader = decodedHeaderTemp;
        this.m_decodedPayload = decodedPayloadTemp;
    }

    public static PureJwt parse(String p_encodedString) {
        if (StringUtils.isNotBlank(p_encodedString)) {
            String[] jwtParts = p_encodedString.split("\\.");
            if (jwtParts.length == 3) {
                return new PureJwt(jwtParts[0], jwtParts[1], jwtParts[2]);
            }
            if (jwtParts.length == 2) {
                return new PureJwt(jwtParts[0], jwtParts[1], "");
            }
        }
        return null;
    }

    public String getDecodedHeader() {
        return this.m_decodedHeader;
    }

    public String getDecodedPayload() {
        return this.m_decodedPayload;
    }

    public String getSigningInput() {
        return this.m_signingInput;
    }

    public String getEncodedHeader() {
        return this.m_encodedHeader;
    }

    public String getEncodedPayload() {
        return this.m_encodedPayload;
    }

    public String getEncodedSignature() {
        return this.m_encodedSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PureJwt pureJwt = (PureJwt)o;
        if (this.m_encodedHeader != null ? !this.m_encodedHeader.equals(pureJwt.m_encodedHeader) : pureJwt.m_encodedHeader != null) {
            return false;
        }
        if (this.m_encodedPayload != null ? !this.m_encodedPayload.equals(pureJwt.m_encodedPayload) : pureJwt.m_encodedPayload != null) {
            return false;
        }
        return !(this.m_encodedSignature != null ? !this.m_encodedSignature.equals(pureJwt.m_encodedSignature) : pureJwt.m_encodedSignature != null);
    }

    public int hashCode() {
        int result = this.m_encodedHeader != null ? this.m_encodedHeader.hashCode() : 0;
        result = 31 * result + (this.m_encodedPayload != null ? this.m_encodedPayload.hashCode() : 0);
        result = 31 * result + (this.m_encodedSignature != null ? this.m_encodedSignature.hashCode() : 0);
        return result;
    }
}

