/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jws;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jws.JwsSigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.model.util.JwtUtil;

public abstract class AbstractJwsSigner
implements JwsSigner {
    private static final Logger LOG = Logger.getLogger(AbstractJwsSigner.class);
    private SignatureAlgorithm signatureAlgorithm;

    public AbstractJwsSigner(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public Jwt sign(Jwt jwt) throws InvalidJwtException, SignatureException {
        String signature = this.generateSignature(jwt.getSigningInput());
        jwt.setEncodedSignature(signature);
        return jwt;
    }

    @Override
    public boolean validate(Jwt jwt) {
        try {
            String signingInput = jwt.getSigningInput();
            String signature = jwt.getEncodedSignature();
            return this.validateSignature(signingInput, signature);
        }
        catch (InvalidJwtException e) {
            LOG.error(e.getMessage(), e);
            return false;
        }
        catch (SignatureException e) {
            LOG.error(e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return false;
        }
    }

    public boolean validateAuthorizationCode(String authorizationCode, Jwt idToken) {
        return this.validateHash(authorizationCode, idToken.getClaims().getClaimAsString("c_hash"));
    }

    public boolean validateAccessToken(String accessToken, Jwt idToken) {
        return this.validateHash(accessToken, idToken.getClaims().getClaimAsString("at_hash"));
    }

    private boolean validateHash(String tokenCode, String tokenHash) {
        boolean result = false;
        try {
            if (this.signatureAlgorithm != null && StringUtils.isNotBlank(tokenCode) && StringUtils.isNotBlank(tokenHash)) {
                byte[] digest = null;
                if (this.signatureAlgorithm == SignatureAlgorithm.HS256 || this.signatureAlgorithm == SignatureAlgorithm.RS256 || this.signatureAlgorithm == SignatureAlgorithm.ES256) {
                    digest = JwtUtil.getMessageDigestSHA256(tokenCode);
                } else if (this.signatureAlgorithm == SignatureAlgorithm.HS384 || this.signatureAlgorithm == SignatureAlgorithm.RS384 || this.signatureAlgorithm == SignatureAlgorithm.ES512) {
                    digest = JwtUtil.getMessageDigestSHA384(tokenCode);
                } else if (this.signatureAlgorithm == SignatureAlgorithm.HS512 || this.signatureAlgorithm == SignatureAlgorithm.RS384 || this.signatureAlgorithm == SignatureAlgorithm.ES512) {
                    digest = JwtUtil.getMessageDigestSHA512(tokenCode);
                }
                if (digest != null) {
                    byte[] lefMostHalf = new byte[digest.length / 2];
                    System.arraycopy(digest, 0, lefMostHalf, 0, lefMostHalf.length);
                    String hash = Base64Util.base64urlencode(lefMostHalf);
                    result = hash.equals(tokenHash);
                }
            }
        }
        catch (NoSuchProviderException e) {
            LOG.error(e.getMessage(), e);
            result = false;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage(), e);
            result = false;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            result = false;
        }
        return result;
    }

    public abstract String generateSignature(String var1) throws SignatureException;

    public abstract boolean validateSignature(String var1, String var2) throws SignatureException;
}

