/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.fido.u2f.protocol;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateRequest;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequest;
import org.xdi.oxauth.model.util.Util;

public class RegisterRequestMessage
implements Serializable {
    private static final long serialVersionUID = -5554834606247337007L;
    @JsonProperty
    private final List<AuthenticateRequest> authenticateRequests;
    @JsonProperty
    private final List<RegisterRequest> registerRequests;

    public RegisterRequestMessage(@JsonProperty(value="authenticateRequests") List<AuthenticateRequest> authenticateRequests, @JsonProperty(value="registerRequests") List<RegisterRequest> registerRequests) {
        this.authenticateRequests = authenticateRequests;
        this.registerRequests = registerRequests;
    }

    public List<AuthenticateRequest> getAuthenticateRequests() {
        return Collections.unmodifiableList(this.authenticateRequests);
    }

    public List<RegisterRequest> getRegisterRequests() {
        return Collections.unmodifiableList(this.registerRequests);
    }

    @JsonIgnore
    public RegisterRequest getRegisterRequest() {
        return Util.firstItem(this.registerRequests);
    }

    @JsonIgnore
    public String getRequestId() {
        return Util.firstItem(this.registerRequests).getChallenge();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegisterRequestMessage [authenticateRequests=").append(this.authenticateRequests).append(", registerRequests=").append(this.registerRequests).append("]");
        return builder.toString();
    }
}

