/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.fido.u2f.protocol;

import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.resteasy.annotations.providers.jaxb.IgnoreMediaTypes;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;

@IgnoreMediaTypes(value={"application/*+json"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticateResponse
implements Serializable {
    private static final long serialVersionUID = -4854326288654670000L;
    @JsonProperty
    private final String clientData;
    @JsonIgnore
    private transient ClientData clientDataRef;
    @JsonProperty
    private final String signatureData;
    @JsonProperty
    private final String keyHandle;

    public AuthenticateResponse(@JsonProperty(value="clientData") String clientData, @JsonProperty(value="signatureData") String signatureData, @JsonProperty(value="keyHandle") String keyHandle) throws BadInputException {
        this.clientData = clientData;
        this.signatureData = signatureData;
        this.keyHandle = keyHandle;
        this.clientDataRef = new ClientData(clientData);
    }

    public ClientData getClientData() {
        return this.clientDataRef;
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    @JsonIgnore
    public String getRequestId() {
        return this.getClientData().getChallenge();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticateResponse [clientData=").append(this.clientData).append(", signatureData=").append(this.signatureData).append(", keyHandle=").append(this.keyHandle).append("]");
        return builder.toString();
    }
}

