/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.encryption;

public enum KeyEncryptionAlgorithm {
    RSA1_5("RSA1_5", "RSA", "RSA/ECB/PKCS1Padding"),
    RSA_OAEP("RSA-OAEP", "RSA", "RSA/ECB/OAEPWithSHA1AndMGF1Padding"),
    A128KW("A128KW"),
    A256KW("A256KW");

    private final String name;
    private final String family;
    private final String algorithm;

    private KeyEncryptionAlgorithm(String name) {
        this.name = name;
        this.family = null;
        this.algorithm = null;
    }

    private KeyEncryptionAlgorithm(String name, String family, String algorithm) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyEncryptionAlgorithm fromName(String name) {
        if (name != null) {
            for (KeyEncryptionAlgorithm a : KeyEncryptionAlgorithm.values()) {
                if (!name.equals(a.name)) continue;
                return a;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

