/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.common.JSONable;
import org.xdi.oxauth.model.crypto.Certificate;
import org.xdi.oxauth.model.crypto.PrivateKey;
import org.xdi.oxauth.model.crypto.PublicKey;

public class Key<E extends PrivateKey, F extends PublicKey>
implements JSONable {
    private String keyType;
    private String use;
    private String algorithm;
    private String keyId;
    private Long expirationTime;
    private Object curve;
    private E privateKey;
    private F publicKey;
    private Certificate certificate;

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Object getCurve() {
        return this.curve;
    }

    public void setCurve(Object curve) {
        this.curve = curve;
    }

    public E getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(E privateKey) {
        this.privateKey = privateKey;
    }

    public F getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(F publicKey) {
        this.publicKey = publicKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("kty", this.getKeyType());
        jsonObject.put("use", this.getUse());
        jsonObject.put("alg", this.getAlgorithm());
        jsonObject.put("kid", this.getKeyId());
        jsonObject.put("exp", this.getExpirationTime() == null ? JSONObject.NULL : this.getExpirationTime());
        jsonObject.put("crv", this.getCurve());
        jsonObject.put("privateKey", this.getPrivateKey().toJSONObject());
        jsonObject.put("publicKey", this.getPublicKey().toJSONObject());
        jsonObject.put("x5c", this.getCertificate().toJSONArray());
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4).replace("\\/", "/");
        }
        catch (JSONException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

