/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto;

import org.xdi.oxauth.model.common.WebKeyStorage;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.OxElevenCryptoProvider;

public class CryptoProviderFactory {
    public static AbstractCryptoProvider getCryptoProvider(AppConfiguration configuration) throws Exception {
        AbstractCryptoProvider cryptoProvider = null;
        WebKeyStorage webKeyStorage = configuration.getWebKeysStorage();
        switch (webKeyStorage) {
            case KEYSTORE: {
                String keyStoreFile = configuration.getKeyStoreFile();
                String keyStoreSecret = configuration.getKeyStoreSecret();
                String dnName = configuration.getDnName();
                cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
                break;
            }
            case PKCS11: {
                cryptoProvider = new OxElevenCryptoProvider(configuration.getOxElevenGenerateKeyEndpoint(), configuration.getOxElevenSignEndpoint(), configuration.getOxElevenVerifySignatureEndpoint(), configuration.getOxElevenDeleteKeyEndpoint(), configuration.getOxElevenTestModeToken());
            }
        }
        return cryptoProvider;
    }
}

