/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto;

import java.io.IOException;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;

public class Certificate {
    private SignatureAlgorithm signatureAlgorithm;
    private X509Certificate x509Certificate;

    public Certificate(SignatureAlgorithm signatureAlgorithm, X509Certificate x509Certificate) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.x509Certificate = x509Certificate;
    }

    public PublicKey getPublicKey() {
        PublicKey publicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof BCRSAPublicKey) {
            BCRSAPublicKey jcersaPublicKey = (BCRSAPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        } else if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof BCECPublicKey) {
            BCECPublicKey jceecPublicKey = (BCECPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new ECDSAPublicKey(this.signatureAlgorithm, jceecPublicKey.getQ().getX().toBigInteger(), jceecPublicKey.getQ().getY().toBigInteger());
        }
        return publicKey;
    }

    public RSAPublicKey getRsaPublicKey() {
        RSAPublicKey rsaPublicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof BCRSAPublicKey) {
            BCRSAPublicKey publicKey = (BCRSAPublicKey)this.x509Certificate.getPublicKey();
            rsaPublicKey = new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent());
        }
        return rsaPublicKey;
    }

    public ECDSAPublicKey getEcdsaPublicKey() {
        ECDSAPublicKey ecdsaPublicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof BCECPublicKey) {
            BCECPublicKey publicKey = (BCECPublicKey)this.x509Certificate.getPublicKey();
            ecdsaPublicKey = new ECDSAPublicKey(this.signatureAlgorithm, publicKey.getQ().getX().toBigInteger(), publicKey.getQ().getY().toBigInteger());
        }
        return ecdsaPublicKey;
    }

    public JSONArray toJSONArray() throws JSONException {
        String cert = this.toString();
        cert = cert.replace("\n", "");
        cert = cert.replace("-----BEGIN CERTIFICATE-----", "");
        cert = cert.replace("-----END CERTIFICATE-----", "");
        return new JSONArray(Arrays.asList(cert));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter(stringWriter);
        try {
            pemWriter.writeObject(this.x509Certificate);
            pemWriter.flush();
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                pemWriter.close();
                throw throwable;
            }
            catch (IOException e) {
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        pemWriter.close();
        return string;
    }
}

