/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseResponseWithErrors;
import org.xdi.oxauth.model.common.TokenType;
import org.xdi.oxauth.model.token.TokenErrorResponseType;

public class TokenResponse
extends BaseResponseWithErrors<TokenErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(TokenResponse.class);
    private String accessToken;
    private TokenType tokenType;
    private Integer expiresIn;
    private String refreshToken;
    private String scope;
    private String idToken;

    public TokenResponse() {
    }

    public TokenResponse(ClientResponse<String> clientResponse) {
        super(clientResponse);
    }

    @Override
    public TokenErrorResponseType fromString(String p_str) {
        return TokenErrorResponseType.fromString(p_str);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.entity);
    }

    @Override
    public void injectDataFromJson(String p_json) {
        if (StringUtils.isNotBlank(this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has("access_token")) {
                    this.setAccessToken(jsonObj.getString("access_token"));
                }
                if (jsonObj.has("token_type")) {
                    this.setTokenType(TokenType.fromString(jsonObj.getString("token_type")));
                }
                if (jsonObj.has("expires_in")) {
                    this.setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("refresh_token")) {
                    this.setRefreshToken(jsonObj.getString("refresh_token"));
                }
                if (jsonObj.has("scope")) {
                    this.setScope(jsonObj.getString("scope"));
                }
                if (jsonObj.has("id_token")) {
                    this.setIdToken(jsonObj.getString("id_token"));
                }
            }
            catch (JSONException e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }
}

