/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryRequest;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryResponse;
import org.xdi.oxauth.model.discovery.WebFingerLink;

public class OpenIdConnectDiscoveryClient
extends BaseClient<OpenIdConnectDiscoveryRequest, OpenIdConnectDiscoveryResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConnectDiscoveryClient.class);
    private static final String MEDIA_TYPE = "application/json";
    private static final String SCHEMA = "https://";
    private static final String PATH = "/.well-known/webfinger";

    public OpenIdConnectDiscoveryClient(String resource) throws URISyntaxException {
        this.setRequest(new OpenIdConnectDiscoveryRequest(resource));
        this.setUrl(SCHEMA + ((OpenIdConnectDiscoveryRequest)this.getRequest()).getHost() + PATH);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConnectDiscoveryResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public OpenIdConnectDiscoveryResponse exec(ClientExecutor executor) {
        this.clientRequest = new ClientRequest(this.getUrl(), executor);
        return this._exec();
    }

    private OpenIdConnectDiscoveryResponse _exec() {
        OpenIdConnectDiscoveryResponse response = null;
        try {
            response = this._exec2();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    private OpenIdConnectDiscoveryResponse _exec2() {
        this.clientRequest.accept(MEDIA_TYPE);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (StringUtils.isNotBlank(((OpenIdConnectDiscoveryRequest)this.getRequest()).getResource())) {
            this.clientRequest.queryParameter("resource", ((OpenIdConnectDiscoveryRequest)this.getRequest()).getResource());
        }
        this.clientRequest.queryParameter("rel", "http://openid.net/specs/connect/1.0/issuer");
        try {
            ClientResponse<String> clientResponse1 = this.clientRequest.get(String.class);
            int status = clientResponse1.getStatus();
            this.setResponse(new OpenIdConnectDiscoveryResponse(status));
            String entity = clientResponse1.getEntity(String.class);
            ((OpenIdConnectDiscoveryResponse)this.getResponse()).setEntity(entity);
            ((OpenIdConnectDiscoveryResponse)this.getResponse()).setHeaders(clientResponse1.getMetadata());
            if (StringUtils.isNotBlank(entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                ((OpenIdConnectDiscoveryResponse)this.getResponse()).setSubject(jsonObj.getString("subject"));
                JSONArray linksJsonArray = jsonObj.getJSONArray("links");
                for (int i = 0; i < linksJsonArray.length(); ++i) {
                    WebFingerLink webFingerLink = new WebFingerLink();
                    webFingerLink.setRel(linksJsonArray.getJSONObject(i).getString("rel"));
                    webFingerLink.setHref(linksJsonArray.getJSONObject(i).getString("href"));
                    ((OpenIdConnectDiscoveryResponse)this.getResponse()).getLinks().add(webFingerLink);
                }
            }
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return (OpenIdConnectDiscoveryResponse)this.getResponse();
    }
}

