/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConfigurationRequest;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.model.util.Util;

public class OpenIdConfigurationClient
extends BaseClient<OpenIdConfigurationRequest, OpenIdConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConfigurationClient.class);
    private static final String mediaType = "text/plain";

    public OpenIdConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConfigurationResponse execOpenIdConfiguration() {
        this.initClientRequest();
        return this._execOpenIdConfiguration();
    }

    @Deprecated
    public OpenIdConfigurationResponse execOpenIdConfiguration(ClientExecutor executor) {
        this.clientRequest = new ClientRequest(this.getUrl(), executor);
        return this._execOpenIdConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenIdConfigurationResponse _execOpenIdConfiguration() {
        this.setRequest(new OpenIdConfigurationRequest());
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new OpenIdConfigurationResponse(status));
            String entity = this.clientResponse.getEntity(String.class);
            ((OpenIdConfigurationResponse)this.getResponse()).setEntity(entity);
            ((OpenIdConfigurationResponse)this.getResponse()).setHeaders(this.clientResponse.getMetadata());
            if (StringUtils.isNotBlank(entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("issuer")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setIssuer(jsonObj.getString("issuer"));
                }
                if (jsonObj.has("authorization_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setAuthorizationEndpoint(jsonObj.getString("authorization_endpoint"));
                }
                if (jsonObj.has("token_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setTokenEndpoint(jsonObj.getString("token_endpoint"));
                }
                if (jsonObj.has("userinfo_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setUserInfoEndpoint(jsonObj.getString("userinfo_endpoint"));
                }
                if (jsonObj.has("clientinfo_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setClientInfoEndpoint(jsonObj.getString("clientinfo_endpoint"));
                }
                if (jsonObj.has("check_session_iframe")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setCheckSessionIFrame(jsonObj.getString("check_session_iframe"));
                }
                if (jsonObj.has("end_session_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setEndSessionEndpoint(jsonObj.getString("end_session_endpoint"));
                }
                if (jsonObj.has("jwks_uri")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setJwksUri(jsonObj.getString("jwks_uri"));
                }
                if (jsonObj.has("registration_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRegistrationEndpoint(jsonObj.getString("registration_endpoint"));
                }
                if (jsonObj.has("id_generation_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setIdGenerationEndpoint(jsonObj.getString("id_generation_endpoint"));
                }
                if (jsonObj.has("introspection_endpoint")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setIntrospectionEndpoint(jsonObj.getString("introspection_endpoint"));
                }
                if (jsonObj.has("scope_to_claims_mapping")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setScopeToClaimsMapping(OpenIdConfigurationResponse.parseScopeToClaimsMapping(jsonObj.getJSONArray("scope_to_claims_mapping")));
                }
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getScopesSupported(), jsonObj, "scopes_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getResponseTypesSupported(), jsonObj, "response_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getGrantTypesSupported(), jsonObj, "grant_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getAcrValuesSupported(), jsonObj, "acr_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getSubjectTypesSupported(), jsonObj, "subject_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUserInfoSigningAlgValuesSupported(), jsonObj, "userinfo_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUserInfoEncryptionAlgValuesSupported(), jsonObj, "userinfo_encryption_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUserInfoEncryptionEncValuesSupported(), jsonObj, "userinfo_encryption_enc_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getIdTokenSigningAlgValuesSupported(), jsonObj, "id_token_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getIdTokenEncryptionAlgValuesSupported(), jsonObj, "id_token_encryption_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getIdTokenEncryptionEncValuesSupported(), jsonObj, "id_token_encryption_enc_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getRequestObjectSigningAlgValuesSupported(), jsonObj, "request_object_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getRequestObjectEncryptionAlgValuesSupported(), jsonObj, "request_object_encryption_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getRequestObjectEncryptionEncValuesSupported(), jsonObj, "request_object_encryption_enc_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getTokenEndpointAuthMethodsSupported(), jsonObj, "token_endpoint_auth_methods_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getTokenEndpointAuthSigningAlgValuesSupported(), jsonObj, "token_endpoint_auth_signing_alg_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getDisplayValuesSupported(), jsonObj, "display_values_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getClaimTypesSupported(), jsonObj, "claim_types_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getClaimsSupported(), jsonObj, "claims_supported");
                if (jsonObj.has("service_documentation")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setServiceDocumentation(jsonObj.getString("service_documentation"));
                }
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getClaimsLocalesSupported(), jsonObj, "claims_locales_supported");
                Util.addToListIfHas(((OpenIdConfigurationResponse)this.getResponse()).getUiLocalesSupported(), jsonObj, "ui_locales_supported");
                if (jsonObj.has("claims_parameter_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setClaimsParameterSupported(jsonObj.getBoolean("claims_parameter_supported"));
                }
                if (jsonObj.has("request_parameter_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRequestParameterSupported(jsonObj.getBoolean("request_parameter_supported"));
                }
                if (jsonObj.has("request_uri_parameter_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRequestUriParameterSupported(jsonObj.getBoolean("request_uri_parameter_supported"));
                }
                if (jsonObj.has("frontchannel_logout_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setFrontChannelLogoutSupported(jsonObj.getBoolean("frontchannel_logout_supported"));
                }
                if (jsonObj.has("frontchannel_logout_session_supported")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setFrontChannelLogoutSessionSupported(jsonObj.getBoolean("frontchannel_logout_session_supported"));
                }
                if (jsonObj.has("require_request_uri_registration")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setRequireRequestUriRegistration(jsonObj.getBoolean("require_request_uri_registration"));
                }
                if (jsonObj.has("op_policy_uri")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setOpPolicyUri(jsonObj.getString("op_policy_uri"));
                }
                if (jsonObj.has("op_tos_uri")) {
                    ((OpenIdConfigurationResponse)this.getResponse()).setOpTosUri(jsonObj.getString("op_tos_uri"));
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            this.closeConnection();
        }
        return (OpenIdConfigurationResponse)this.getResponse();
    }
}

