/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xdi.oxauth.client.BaseResponse;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithmFamily;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;

public class JwkResponse
extends BaseResponse {
    private JSONWebKeySet jwks;

    public JwkResponse(int status) {
        super(status);
    }

    public JSONWebKeySet getJwks() {
        return this.jwks;
    }

    public void setJwks(JSONWebKeySet jwks) {
        this.jwks = jwks;
    }

    @Deprecated
    public JSONWebKey getKeyValue(String keyId) {
        for (JSONWebKey JSONWebKey2 : this.jwks.getKeys()) {
            if (!JSONWebKey2.getKid().equals(keyId)) continue;
            return JSONWebKey2;
        }
        return null;
    }

    @Deprecated
    public PublicKey getPublicKey(String keyId) {
        PublicKey publicKey = null;
        JSONWebKey JSONWebKey2 = this.getKeyValue(keyId);
        if (JSONWebKey2 != null) {
            switch (JSONWebKey2.getKty()) {
                case RSA: {
                    publicKey = new RSAPublicKey(JSONWebKey2.getN(), JSONWebKey2.getE());
                    break;
                }
                case EC: {
                    publicKey = new ECDSAPublicKey(JSONWebKey2.getAlg(), JSONWebKey2.getX(), JSONWebKey2.getY());
                    break;
                }
            }
        }
        return publicKey;
    }

    public List<JSONWebKey> getKeys(SignatureAlgorithm algorithm) {
        ArrayList<JSONWebKey> jsonWebKeys = new ArrayList<JSONWebKey>();
        if (SignatureAlgorithmFamily.RSA.equals((Object)algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.jwks.getKeys()) {
                if (!jsonWebKey.getAlg().equals((Object)algorithm)) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        } else if (SignatureAlgorithmFamily.EC.equals((Object)algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.jwks.getKeys()) {
                if (!jsonWebKey.getAlg().equals((Object)algorithm)) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        }
        Collections.sort(jsonWebKeys);
        return jsonWebKeys;
    }

    public String getKeyId(SignatureAlgorithm signatureAlgorithm) {
        List<JSONWebKey> jsonWebKeys = this.getKeys(signatureAlgorithm);
        if (jsonWebKeys.size() > 0) {
            return jsonWebKeys.get(0).getKid();
        }
        return null;
    }
}

