/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.util.Util;

public class EndSessionClient
extends BaseClient<EndSessionRequest, EndSessionResponse> {
    private static final String mediaType = "text/plain";

    public EndSessionClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public EndSessionResponse execEndSession(String idTokenHint, String postLogoutRedirectUri, String state) {
        this.setRequest(new EndSessionRequest(idTokenHint, postLogoutRedirectUri, state));
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndSessionResponse exec() {
        block16: {
            this.initClientRequest();
            this.clientRequest.accept(mediaType);
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (StringUtils.isNotBlank(((EndSessionRequest)this.getRequest()).getIdTokenHint())) {
                this.clientRequest.queryParameter("id_token_hint", ((EndSessionRequest)this.getRequest()).getIdTokenHint());
            }
            if (StringUtils.isNotBlank(((EndSessionRequest)this.getRequest()).getPostLogoutRedirectUri())) {
                this.clientRequest.queryParameter("post_logout_redirect_uri", ((EndSessionRequest)this.getRequest()).getPostLogoutRedirectUri());
            }
            if (StringUtils.isNotBlank(((EndSessionRequest)this.getRequest()).getState())) {
                this.clientRequest.queryParameter("state", ((EndSessionRequest)this.getRequest()).getState());
            }
            if (StringUtils.isNotBlank(((EndSessionRequest)this.getRequest()).getSessionId())) {
                this.clientRequest.queryParameter("session_id", ((EndSessionRequest)this.getRequest()).getSessionId());
            }
            try {
                this.clientResponse = this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.setResponse(new EndSessionResponse(status));
                String entity = this.clientResponse.getEntity(String.class);
                ((EndSessionResponse)this.getResponse()).setEntity(entity);
                ((EndSessionResponse)this.getResponse()).setHeaders(this.clientResponse.getMetadata());
                if (this.clientResponse.getLocationLink() != null) {
                    String queryString;
                    Map<String, String> params;
                    String location = this.clientResponse.getLocationLink().getHref();
                    ((EndSessionResponse)this.getResponse()).setLocation(location);
                    int queryStringIndex = location.indexOf("?");
                    if (queryStringIndex != -1 && (params = QueryStringDecoder.decode(queryString = location.substring(queryStringIndex + 1))).containsKey("state")) {
                        ((EndSessionResponse)this.getResponse()).setState(params.get("state"));
                    }
                }
                if (Util.isNullOrEmpty(entity) || entity.contains("<html>")) break block16;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        ((EndSessionResponse)this.getResponse()).setErrorType(EndSessionErrorResponseType.fromString(jsonObj.getString("error")));
                    }
                    if (jsonObj.has("error_description")) {
                        ((EndSessionResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                    }
                    if (jsonObj.has("error_uri")) {
                        ((EndSessionResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return (EndSessionResponse)this.getResponse();
    }
}

