/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.core.interception.DecoratorMatcher;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBMarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.SecureUnmarshaller;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.NoContent;
import org.jboss.resteasy.util.TypeConverter;
import org.xml.sax.InputSource;

public abstract class AbstractJAXBProvider<T>
extends AbstractEntityProvider<T> {
    @Context
    protected Providers providers;
    private boolean disableExternalEntities = true;
    private boolean enableSecureProcessingFeature = true;
    private boolean disableDTDs = true;

    public AbstractJAXBProvider() {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : AbstractJAXBProvider", (Object)this.getClass().getName());
        ResteasyConfiguration context = ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
        if (context != null) {
            String s = context.getParameter("resteasy.document.expand.entity.references");
            if (s != null) {
                this.setDisableExternalEntities(!Boolean.parseBoolean(s));
            }
            if ((s = context.getParameter("resteasy.document.secure.processing.feature")) != null) {
                this.setEnableSecureProcessingFeature(Boolean.parseBoolean(s));
            }
            if ((s = context.getParameter("resteasy.document.secure.disableDTDs")) != null) {
                this.setDisableDTDs(Boolean.parseBoolean(s));
            }
        }
    }

    public JAXBContext findJAXBContext(Class<?> type, Annotation[] annotations, MediaType mediaType, boolean reader) throws JAXBException {
        ContextResolver<JAXBContextFinder> resolver = this.providers.getContextResolver(JAXBContextFinder.class, mediaType);
        JAXBContextFinder finder = resolver.getContext(type);
        if (finder == null) {
            if (reader) {
                throw new JAXBUnmarshalException(Messages.MESSAGES.couldNotFindJAXBContextFinder(mediaType));
            }
            throw new JAXBMarshalException(Messages.MESSAGES.couldNotFindJAXBContextFinder(mediaType));
        }
        return finder.findCachedContext(type, mediaType, annotations);
    }

    public static Marshaller decorateMarshaller(Class type, Annotation[] annotations, MediaType mediaType, Marshaller marshaller) throws JAXBException {
        DecoratorMatcher processor = new DecoratorMatcher();
        return processor.decorate(Marshaller.class, marshaller, type, annotations, mediaType);
    }

    public static Unmarshaller decorateUnmarshaller(Class type, Annotation[] annotations, MediaType mediaType, Unmarshaller marshaller) throws JAXBException {
        DecoratorMatcher processor = new DecoratorMatcher();
        return processor.decorate(Unmarshaller.class, marshaller, type, annotations, mediaType);
    }

    @Override
    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
            NoContent.contentLengthCheck(httpHeaders);
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType, true);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller = AbstractJAXBProvider.decorateUnmarshaller(type, annotations, mediaType, unmarshaller);
            if (this.needsSecurity()) {
                return this.processWithSecureProcessing(unmarshaller, entityStream, AbstractJAXBProvider.getCharset(mediaType));
            }
            if (AbstractJAXBProvider.getCharset(mediaType) == null) {
                InputSource is = new InputSource(entityStream);
                is.setEncoding(StandardCharsets.UTF_8.name());
                StreamSource source = new StreamSource(new InputStreamReader(entityStream, StandardCharsets.UTF_8));
                source.setInputStream(entityStream);
                return (T)unmarshaller.unmarshal(source);
            }
            return (T)unmarshaller.unmarshal(new StreamSource(entityStream));
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
    }

    @Override
    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
            Marshaller marshaller = this.getMarshaller(type, annotations, mediaType);
            marshaller = AbstractJAXBProvider.decorateMarshaller(type, annotations, mediaType, marshaller);
            marshaller.marshal(t, outputStream);
        }
        catch (JAXBException e) {
            throw new JAXBMarshalException(e);
        }
    }

    protected Marshaller getMarshaller(Class<?> type, Annotation[] annotations, MediaType mediaType) {
        try {
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType, false);
            Marshaller marshaller = jaxb.createMarshaller();
            AbstractJAXBProvider.setCharset(mediaType, marshaller);
            String formatted = mediaType.getParameters().get("formatted");
            if (formatted != null) {
                Boolean value = TypeConverter.getBooleanValue(formatted.toString());
                marshaller.setProperty("jaxb.formatted.output", value);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw new JAXBMarshalException(e);
        }
    }

    public static void setCharset(MediaType mediaType, Marshaller marshaller) throws PropertyException {
        String charset = AbstractJAXBProvider.getCharset(mediaType);
        if (charset != null) {
            marshaller.setProperty("jaxb.encoding", charset);
        } else {
            marshaller.setProperty("jaxb.encoding", StandardCharsets.UTF_8.name());
        }
    }

    protected abstract boolean isReadWritable(Class<?> var1, Type var2, Annotation[] var3, MediaType var4);

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadWritable(type, genericType, annotations, mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadWritable(type, genericType, annotations, mediaType);
    }

    public static String getCharset(MediaType mediaType) {
        if (mediaType != null) {
            return mediaType.getParameters().get("charset");
        }
        return null;
    }

    public boolean isDisableExternalEntities() {
        return this.disableExternalEntities;
    }

    public void setDisableExternalEntities(boolean disableExternalEntities) {
        this.disableExternalEntities = disableExternalEntities;
    }

    public boolean isEnableSecureProcessingFeature() {
        return this.enableSecureProcessingFeature;
    }

    public void setEnableSecureProcessingFeature(boolean enableSecureProcessingFeature) {
        this.enableSecureProcessingFeature = enableSecureProcessingFeature;
    }

    public boolean isDisableDTDs() {
        return this.disableDTDs;
    }

    public void setDisableDTDs(boolean disableDTDs) {
        this.disableDTDs = disableDTDs;
    }

    protected boolean needsSecurity() {
        return true;
    }

    protected T processWithSecureProcessing(Unmarshaller unmarshaller, InputStream entityStream, String charset) throws JAXBException {
        unmarshaller = new SecureUnmarshaller(unmarshaller, this.disableExternalEntities, this.enableSecureProcessingFeature, this.disableDTDs);
        if (charset == null) {
            InputSource is = new InputSource(entityStream);
            is.setEncoding(StandardCharsets.UTF_8.name());
            return (T)unmarshaller.unmarshal(is);
        }
        return (T)unmarshaller.unmarshal(entityStream);
    }
}

