/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared.descriptor.sql;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;

public class DstSafeTimestampTypeDescriptor
extends TimestampTypeDescriptor {
    private static final long serialVersionUID = -1927559005967709998L;
    private final Calendar cal;
    public static final DstSafeTimestampTypeDescriptor INSTANCE = new DstSafeTimestampTypeDescriptor();

    public DstSafeTimestampTypeDescriptor() {
        this.cal = null;
    }

    public DstSafeTimestampTypeDescriptor(Calendar cal) {
        this.cal = cal;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (DstSafeTimestampTypeDescriptor.this.cal == null) {
                    st.setTimestamp(index, javaTypeDescriptor.unwrap(value, Timestamp.class, options));
                } else {
                    st.setTimestamp(index, javaTypeDescriptor.unwrap(value, Timestamp.class, options), DstSafeTimestampTypeDescriptor.this.cal);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                if (DstSafeTimestampTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap(rs.getTimestamp(name), options);
                }
                return javaTypeDescriptor.wrap(rs.getTimestamp(name, DstSafeTimestampTypeDescriptor.this.cal), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (DstSafeTimestampTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap(statement.getTimestamp(index), options);
                }
                return javaTypeDescriptor.wrap(statement.getTimestamp(index, DstSafeTimestampTypeDescriptor.this.cal), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (DstSafeTimestampTypeDescriptor.this.cal == null) {
                    return javaTypeDescriptor.wrap(statement.getTimestamp(name), options);
                }
                return javaTypeDescriptor.wrap(statement.getTimestamp(name, DstSafeTimestampTypeDescriptor.this.cal), options);
            }
        };
    }
}

