/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.jadira.usertype.spi.shared.AbstractUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;
import org.jadira.usertype.spi.utils.reflection.TypeHelper;

public abstract class AbstractSingleColumnUserType<T, J, C extends ColumnMapper<T, J>>
extends AbstractUserType
implements EnhancedUserType,
Serializable {
    private static final long serialVersionUID = -8258683760413283329L;
    private final C columnMapper;
    private final int[] sqlTypes;

    public AbstractSingleColumnUserType() {
        try {
            this.columnMapper = (ColumnMapper)TypeHelper.getTypeArguments(AbstractSingleColumnUserType.class, this.getClass()).get(2).newInstance();
        }
        catch (InstantiationException ex) {
            throw new HibernateException("Could not initialise column mapper for " + this.getClass(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new HibernateException("Could not access column mapper for " + this.getClass(), ex);
        }
        this.sqlTypes = new int[]{this.getColumnMapper().getSqlType()};
    }

    public final C getColumnMapper() {
        return this.columnMapper;
    }

    @Override
    public Class<T> returnedClass() {
        return this.getColumnMapper().returnedClass();
    }

    @Override
    public final int[] sqlTypes() {
        return ArrayUtils.copyOf(this.sqlTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T nullSafeGet(ResultSet resultSet, String[] strings, SessionImplementor session, Object object) throws SQLException {
        this.beforeNullSafeOperation(session);
        try {
            J converted = this.doNullSafeGet(resultSet, strings, session, object);
            if (converted == null) {
                T t = null;
                return t;
            }
            Object t = this.getColumnMapper().fromNonNullValue(converted);
            return t;
        }
        finally {
            this.afterNullSafeOperation(session);
        }
    }

    protected J doNullSafeGet(ResultSet resultSet, String[] strings, SessionImplementor session, Object object) throws SQLException {
        Object converted = this.getColumnMapper().getHibernateType().nullSafeGet(resultSet, strings[0], session, object);
        return (J)converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws SQLException {
        this.beforeNullSafeOperation(session);
        try {
            J transformedValue;
            if (value == null) {
                transformedValue = null;
            } else {
                Object myValue = value;
                transformedValue = this.getColumnMapper().toNonNullValue((Object)myValue);
            }
            this.doNullSafeSet(preparedStatement, transformedValue, index, session);
        }
        finally {
            this.afterNullSafeOperation(session);
        }
    }

    protected void doNullSafeSet(PreparedStatement preparedStatement, J transformedValue, int index, SessionImplementor session) throws SQLException {
        this.getColumnMapper().getHibernateType().nullSafeSet(preparedStatement, transformedValue, index, session);
    }

    @Override
    public String objectToSQLString(Object object) {
        Object myObject = object;
        Object convertedObject = myObject == null ? null : (Object)this.getColumnMapper().toNonNullValue((Object)myObject);
        return this.getColumnMapper().getHibernateType().toString(convertedObject);
    }

    @Override
    public String toXMLString(Object object) {
        Object myObject = object;
        return this.getColumnMapper().toNonNullString((Object)myObject);
    }

    public T fromXMLString(String string) {
        return this.getColumnMapper().fromNonNullString(string);
    }
}

