/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.jadira.usertype.spi.shared.AbstractHeuristicUserType;
import org.jadira.usertype.spi.utils.reflection.TypeHelper;

public abstract class AbstractReflectionUserType<T>
extends AbstractHeuristicUserType
implements EnhancedUserType,
Serializable {
    private static final long serialVersionUID = 7943328235820102665L;
    private Class<?> mappedClass;
    private Method identifierMethod;
    private Method valueOfMethod;

    protected void setMappedClass(Class<?> mappedClass) {
        this.mappedClass = mappedClass;
    }

    protected Class<?> getMappedClass() {
        return this.mappedClass;
    }

    protected void setIdentifierMethod(Method identifierMethod) {
        this.identifierMethod = identifierMethod;
    }

    protected Method getIdentifierMethod() {
        return this.identifierMethod;
    }

    protected void setValueOfMethod(Method valueOfMethod) {
        if (!Modifier.isStatic(valueOfMethod.getModifiers())) {
            throw new IllegalStateException("valueOfMethod must be static: " + valueOfMethod.toString());
        }
        this.valueOfMethod = valueOfMethod;
    }

    protected Method getValueOfMethod() {
        return this.valueOfMethod;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        if (this.mappedClass == null) {
            throw new IllegalStateException("No mapped class was defined for " + this.getClass().getName());
        }
        if (this.identifierMethod == null) {
            throw new IllegalStateException("No identifier method was defined for " + this.getClass().getName());
        }
        this.setIdentifierType(this.identifierMethod.getReturnType());
        super.setParameterValues(parameters);
    }

    @Override
    public Class<T> returnedClass() {
        return TypeHelper.getTypeArguments(AbstractReflectionUserType.class, this.getClass()).get(0);
    }

    @Override
    public Object doNullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object identifier = this.getType().get(rs, names[0], session);
        if (rs.wasNull()) {
            return null;
        }
        return this.valueOfMethod.invoke(this.mappedClass, identifier);
    }

    @Override
    public void doNullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            preparedStatement.setNull(index, this.getType().sqlType());
        } else {
            Object identifier = this.identifierMethod.invoke(value, new Object[0]);
            this.getType().nullSafeSet(preparedStatement, identifier, index, session);
        }
    }

    @Override
    public String objectToSQLString(Object object) {
        if (object == null) {
            return null;
        }
        if (this.identifierMethod != null) {
            try {
                return String.valueOf(this.identifierMethod.invoke(object, new Object[0]));
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return super.objectToSQLString(object);
    }

    @Override
    public String toXMLString(Object object) {
        if (this.identifierMethod != null) {
            try {
                return String.valueOf(this.identifierMethod.invoke(object, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw new HibernateException("Problem constructing XMLString: " + object + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Problem constructing XMLString: " + object + "'", e);
            }
        }
        return super.toXMLString(object);
    }
}

