/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.usertype.spi.shared.AbstractMultiColumnUserType;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.IntegratorConfiguredType;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public abstract class AbstractParameterizedMultiColumnUserType<T>
extends AbstractMultiColumnUserType<T>
implements ParameterizedType,
IntegratorConfiguredType {
    private static final long serialVersionUID = -5378286101759906332L;
    private Properties parameterValues;

    @Override
    public void setParameterValues(Properties parameters) {
        this.parameterValues = parameters;
    }

    protected Properties getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public void applyConfiguration(SessionFactory sessionFactory) {
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        Object next;
        if (DatabaseZoneConfigured.class.isAssignableFrom(this.getClass())) {
            next = (DatabaseZoneConfigured)((Object)this);
            this.performDatabaseZoneConfiguration((DatabaseZoneConfigured<Z>)next);
        }
        if (JavaZoneConfigured.class.isAssignableFrom(this.getClass())) {
            next = (JavaZoneConfigured)((Object)this);
            this.performJavaZoneConfiguration((JavaZoneConfigured<Z>)next);
        }
        for (int i = 0; i < this.getColumnMappers().length; ++i) {
            Object next2;
            if (DatabaseZoneConfigured.class.isAssignableFrom(this.getColumnMappers()[i].getClass())) {
                next2 = (DatabaseZoneConfigured)((Object)this.getColumnMappers()[i]);
                this.performDatabaseZoneConfiguration((DatabaseZoneConfigured<Z>)next2);
            }
            if (!JavaZoneConfigured.class.isAssignableFrom(this.getColumnMappers()[i].getClass())) continue;
            next2 = (JavaZoneConfigured)((Object)this.getColumnMappers()[i]);
            this.performJavaZoneConfiguration((JavaZoneConfigured<Z>)next2);
        }
    }

    private <Z> void performDatabaseZoneConfiguration(DatabaseZoneConfigured<Z> next) {
        String databaseZone = null;
        if (this.getParameterValues() != null) {
            databaseZone = this.getParameterValues().getProperty("databaseZone");
        }
        if (databaseZone == null) {
            databaseZone = ConfigurationHelper.getProperty("databaseZone");
        }
        if (databaseZone != null) {
            if ("jvm".equals(databaseZone)) {
                next.setDatabaseZone(null);
            } else {
                next.setDatabaseZone(next.parseZone(databaseZone));
            }
        }
    }

    private <Z> void performJavaZoneConfiguration(JavaZoneConfigured<Z> next) {
        String javaZone = null;
        if (this.getParameterValues() != null) {
            javaZone = this.getParameterValues().getProperty("javaZone");
        }
        if (javaZone == null) {
            javaZone = ConfigurationHelper.getProperty("javaZone");
        }
        if (javaZone != null) {
            if ("jvm".equals(javaZone)) {
                next.setJavaZone(null);
            } else {
                next.setJavaZone(next.parseZone(javaZone));
            }
        }
    }
}

