/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.TypeResolver;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.usertype.EnhancedUserType;
import org.jadira.usertype.spi.shared.AbstractUserType;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;

public abstract class AbstractHeuristicUserType
extends AbstractUserType
implements EnhancedUserType,
Serializable {
    private static final long serialVersionUID = 7099384329368123541L;
    private Class<?> identifierType;
    private AbstractSingleColumnStandardBasicType<?> type;
    private int[] sqlTypes;

    protected void setIdentifierType(Class<?> identifierType) {
        this.identifierType = identifierType;
    }

    protected Class<?> getIdentifierType() {
        return this.identifierType;
    }

    protected AbstractSingleColumnStandardBasicType<?> getType() {
        return this.type;
    }

    public void setParameterValues(Properties parameters) {
        AbstractSingleColumnStandardBasicType heuristicType = (AbstractSingleColumnStandardBasicType)new TypeResolver().heuristicType(this.identifierType.getName(), parameters);
        if (heuristicType == null) {
            throw new HibernateException("Unsupported identifier type " + this.identifierType.getName());
        }
        this.type = heuristicType;
        this.sqlTypes = new int[]{this.type.sqlType()};
    }

    @Override
    public int[] sqlTypes() {
        return ArrayUtils.copyOf(this.sqlTypes);
    }

    @Override
    public abstract Class<?> returnedClass();

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        this.beforeNullSafeOperation(session);
        try {
            Object object = this.doNullSafeGet(rs, names, session, owner);
            return object;
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException("Exception during nullSafeGet of type '" + this.identifierType.getName() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Exception during nullSafeGet of type '" + this.identifierType.getName() + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Exception during nullSafeGet of type '" + this.identifierType.getName() + "'", e);
        }
        finally {
            this.afterNullSafeOperation(session);
        }
    }

    public abstract Object doNullSafeGet(ResultSet var1, String[] var2, SessionImplementor var3, Object var4) throws HibernateException, SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws SQLException {
        this.beforeNullSafeOperation(session);
        try {
            this.doNullSafeSet(preparedStatement, value, index, session);
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException("Exception during nullSafeSet of type '" + this.identifierType.getName() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Exception during nullSafeSet of type '" + this.identifierType.getName() + "'", e);
        }
        catch (InvocationTargetException e) {
        }
        finally {
            this.afterNullSafeOperation(session);
        }
    }

    public abstract void doNullSafeSet(PreparedStatement var1, Object var2, int var3, SessionImplementor var4) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    @Override
    public String objectToSQLString(Object object) {
        JavaTypeDescriptor<Object> desc = this.type.getJavaTypeDescriptor();
        return desc.toString(object);
    }

    @Override
    public String toXMLString(Object object) {
        JavaTypeDescriptor<Object> desc = this.type.getJavaTypeDescriptor();
        return desc.toString(object);
    }

    @Override
    public Object fromXMLString(String string) {
        return this.type.fromString(string);
    }
}

