/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.repository;

import java.io.Serializable;
import javax.persistence.LockModeType;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.metadata.ClassMetadata;
import org.jadira.usertype.spi.repository.BaseRepository;
import org.jadira.usertype.spi.repository.JpaSearchRepository;
import org.jadira.usertype.spi.utils.reflection.TypeHelper;

public abstract class JpaBaseRepository<T extends Serializable, ID extends Serializable>
extends JpaSearchRepository<T, ID>
implements BaseRepository<T, ID> {
    protected JpaBaseRepository() {
    }

    protected ID extractId(T entity) {
        Class<?> entityClass = TypeHelper.getTypeArguments(JpaBaseRepository.class, this.getClass()).get(0);
        SessionFactory sf = ((HibernateEntityManagerFactory)this.getEntityManager().getEntityManagerFactory()).getSessionFactory();
        ClassMetadata cmd = sf.getClassMetadata(entityClass);
        SessionImplementor si = (SessionImplementor)this.getEntityManager().getDelegate();
        Serializable result = cmd.getIdentifier(entity, si);
        return (ID)result;
    }

    @Override
    public T persist(T entity) {
        if (this.extractId(entity) == null) {
            this.getEntityManager().persist(entity);
        } else if (!this.getEntityManager().contains(entity)) {
            entity = (Serializable)this.getEntityManager().merge(entity);
        }
        return entity;
    }

    @Override
    public void remove(ID entityId) {
        Serializable entity = (Serializable)this.getEntityManager().find(this.getEntityClass(), entityId);
        if (this.getEntityManager().contains(entity)) {
            this.getEntityManager().remove(entity);
        } else {
            entity = this.getEntityManager().merge(entity);
            this.getEntityManager().remove(entity);
        }
    }

    @Override
    public T refresh(T entity) {
        if (this.extractId(entity) == null) {
            this.getEntityManager().refresh(entity);
        } else if (this.getEntityManager().contains(entity)) {
            this.getEntityManager().refresh(entity);
        } else {
            entity = (Serializable)this.getEntityManager().merge(entity);
            this.getEntityManager().refresh(entity);
        }
        return entity;
    }

    @Override
    public T evict(T entity) {
        Session session = (Session)this.getEntityManager().getDelegate();
        session.evict(entity);
        return entity;
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    @Override
    public void lock(T entity, LockModeType lockMode) {
        this.getEntityManager().lock(entity, lockMode);
    }
}

