/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.jta;

import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.jta.JtaTransactionManager;

public class HibernateEntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    private JtaTransactionManager transactionManager;
    private static final ThreadLocal<JtaTransactionManager> configurationTransactionManagerHolder = new ThreadLocal();

    static JtaTransactionManager getConfigurationTransactionManager() {
        return configurationTransactionManagerHolder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        if (this.transactionManager != null) {
            configurationTransactionManagerHolder.set(this.transactionManager);
        }
        try {
            EntityManagerFactory entityManagerFactory = super.createNativeEntityManagerFactory();
            return entityManagerFactory;
        }
        finally {
            if (this.transactionManager != null) {
                configurationTransactionManagerHolder.set(null);
            }
        }
    }

    public void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

