/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.joda.columnmapper;

import java.math.BigDecimal;
import org.jadira.usertype.moneyandcurrency.joda.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractBigDecimalColumnMapper;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class BigDecimalColumnMoneyMapper
extends AbstractBigDecimalColumnMapper<Money>
implements CurrencyUnitConfigured {
    private static final long serialVersionUID = 4205713919952452881L;
    private CurrencyUnit currencyUnit;

    @Override
    public Money fromNonNullValue(BigDecimal val) {
        return Money.of((CurrencyUnit)this.currencyUnit, (BigDecimal)val);
    }

    @Override
    public BigDecimal toNonNullValue(Money value) {
        if (!this.currencyUnit.equals((Object)value.getCurrencyUnit())) {
            throw new IllegalStateException("Expected currency " + this.currencyUnit.getCurrencyCode() + " but was " + value.getCurrencyUnit());
        }
        return value.getAmount();
    }

    @Override
    public Money fromNonNullString(String s) {
        return Money.parse((String)s);
    }

    @Override
    public String toNonNullString(Money value) {
        return value.toString();
    }

    @Override
    public void setCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
    }
}

