/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimestampThreeTenBPColumnMapper;
import org.jadira.usertype.dateandtime.threetenbp.utils.ZoneHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class TimestampColumnOffsetTimeMapper
extends AbstractTimestampThreeTenBPColumnMapper<OffsetTime>
implements DatabaseZoneConfigured<ZoneOffset>,
JavaZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_TIME_PRINTER = new DateTimeFormatterBuilder().appendPattern("0001-01-01 HH:mm:ss").appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 0, 9, false).toFormatter();
    public static final DateTimeFormatter LOCAL_TIME_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 0, 9, false).toFormatter();
    private static final int MILLIS_IN_SECOND = 1000;
    private ZoneOffset javaZone = null;

    public TimestampColumnOffsetTimeMapper() {
    }

    public TimestampColumnOffsetTimeMapper(ZoneOffset databaseZone, ZoneOffset javaZone) {
        super(databaseZone);
        this.javaZone = javaZone;
    }

    @Override
    public OffsetTime fromNonNullString(String s) {
        return OffsetTime.parse((CharSequence)s);
    }

    @Override
    public OffsetTime fromNonNullValue(Timestamp value) {
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? ZoneHelper.getDefaultZoneOffset() : this.getDatabaseZone();
        ZoneOffset currentJavaZone = this.javaZone == null ? ZoneHelper.getDefaultZoneOffset() : this.javaZone;
        OffsetDateTime dateTime = OffsetDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)value.getTime()), (ZoneId)currentDatabaseZone);
        dateTime = dateTime.with((TemporalField)ChronoField.NANO_OF_SECOND, (long)value.getNanos()).withOffsetSameInstant(currentJavaZone);
        OffsetTime time = dateTime.toOffsetTime();
        return time;
    }

    @Override
    public String toNonNullString(OffsetTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(OffsetTime value) {
        OffsetDateTime odt = value.atDate(LocalDate.of((int)1970, (int)1, (int)1));
        Timestamp timestamp = new Timestamp(odt.toEpochSecond() * 1000L);
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    @Override
    public void setJavaZone(ZoneOffset javaZone) {
        this.javaZone = javaZone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

