/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Timestamp;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimestampThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.Month;
import org.threeten.bp.MonthDay;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class TimestampColumnMonthDayMapper
extends AbstractTimestampThreeTenBPColumnMapper<MonthDay>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public TimestampColumnMonthDayMapper() {
    }

    public TimestampColumnMonthDayMapper(ZoneOffset databaseZone) {
        super(databaseZone);
    }

    @Override
    public MonthDay fromNonNullString(String s) {
        return MonthDay.parse((CharSequence)s);
    }

    @Override
    public MonthDay fromNonNullValue(Timestamp value) {
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        Instant instant = Instant.ofEpochMilli((long)value.getTime());
        instant = instant.with((TemporalField)ChronoField.NANO_OF_SECOND, (long)value.getNanos());
        LocalDateTime ldt = LocalDateTime.ofInstant((Instant)instant, (ZoneId)currentDatabaseZone);
        return MonthDay.of((Month)ldt.getMonth(), (int)ldt.getDayOfMonth());
    }

    @Override
    public String toNonNullString(MonthDay value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(MonthDay value) {
        LocalDateTime ldt = LocalDateTime.of((int)1970, (int)value.getMonthValue(), (int)value.getDayOfMonth(), (int)0, (int)0);
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnMonthDayMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zdt = ldt.atZone((ZoneId)currentDatabaseZone);
        Timestamp timestamp = new Timestamp(zdt.toInstant().toEpochMilli());
        return timestamp;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of((String)"Z");
        }
        return zone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

