/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimestampThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class TimestampColumnLocalTimeMapper
extends AbstractTimestampThreeTenBPColumnMapper<LocalTime>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 1921591625617366103L;
    public static final DateTimeFormatter LOCAL_DATETIME_PRINTER = new DateTimeFormatterBuilder().appendPattern("0001-01-01 HH:mm:ss").appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter LOCAL_DATETIME_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final int MILLIS_IN_SECOND = 1000;

    public TimestampColumnLocalTimeMapper() {
        super(null);
    }

    public TimestampColumnLocalTimeMapper(ZoneOffset databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalTime fromNonNullString(String s) {
        return LocalTime.parse((CharSequence)s);
    }

    @Override
    public LocalTime fromNonNullValue(Timestamp value) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(value.getTime());
        LocalTime time = LocalTime.of((int)cal.get(11), (int)cal.get(12), (int)cal.get(13), (int)(cal.get(14) * 1000000));
        return time;
    }

    @Override
    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(LocalTime value) {
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? TimestampColumnLocalTimeMapper.getDefault() : this.getDatabaseZone();
        LocalDateTime ldt = value.atDate(LocalDate.of((int)1970, (int)1, (int)1));
        ZonedDateTime zdt = ldt.atZone((ZoneId)currentDatabaseZone);
        Instant ins = zdt.toInstant();
        ZoneOffset off = TimestampColumnLocalTimeMapper.getDefault();
        int adjustment = TimeZone.getDefault().getOffset(ins.toEpochMilli()) - off.getRules().getOffset(LocalDateTime.now()).getTotalSeconds() * 1000;
        Timestamp timestamp = new Timestamp(ins.toEpochMilli() - (long)adjustment);
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of((String)"Z");
        }
        return zone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

