/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimestampThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class TimestampColumnInstantMapper
extends AbstractTimestampThreeTenBPColumnMapper<Instant>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public TimestampColumnInstantMapper() {
    }

    public TimestampColumnInstantMapper(ZoneOffset databaseZone) {
        super(databaseZone);
    }

    @Override
    public Instant fromNonNullString(String s) {
        return Instant.parse((CharSequence)s);
    }

    @Override
    public Instant fromNonNullValue(Timestamp value) {
        Instant instant = Instant.ofEpochMilli((long)value.getTime());
        instant = instant.with((TemporalField)ChronoField.NANO_OF_SECOND, (long)value.getNanos());
        return instant;
    }

    @Override
    public String toNonNullString(Instant value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(Instant value) {
        Timestamp timestamp = new Timestamp(value.toEpochMilli());
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

