/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Time;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractTimeThreeTenBPColumnMapper;
import org.jadira.usertype.dateandtime.threetenbp.utils.ZoneHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.TemporalAccessor;

public class TimeColumnOffsetTimeMapper
extends AbstractTimeThreeTenBPColumnMapper<OffsetTime>
implements DatabaseZoneConfigured<ZoneOffset>,
JavaZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();
    private ZoneOffset databaseZone = ZoneOffset.UTC;
    private ZoneOffset javaZone = null;

    public TimeColumnOffsetTimeMapper() {
    }

    public TimeColumnOffsetTimeMapper(ZoneOffset databaseZone, ZoneOffset javaZone) {
        this.databaseZone = databaseZone;
        this.javaZone = javaZone;
    }

    @Override
    public OffsetTime fromNonNullString(String s) {
        return OffsetTime.parse((CharSequence)s);
    }

    @Override
    public OffsetTime fromNonNullValue(Time value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? TimeColumnOffsetTimeMapper.getDefault() : this.databaseZone;
        OffsetDateTime dateTime = Instant.ofEpochMilli((long)value.getTime()).atOffset(currentDatabaseZone);
        return dateTime.toOffsetTime().withOffsetSameInstant(this.javaZone);
    }

    @Override
    public String toNonNullString(OffsetTime value) {
        return value.toString();
    }

    @Override
    public Time toNonNullValue(OffsetTime value) {
        ZoneOffset currentDatabaseZone = this.databaseZone == null ? ZoneHelper.getDefaultZoneOffset() : this.databaseZone;
        OffsetTime adjustedValue = value.withOffsetSameInstant(currentDatabaseZone);
        return Time.valueOf(LOCAL_TIME_FORMATTER.format((TemporalAccessor)adjustedValue));
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of((String)"Z");
        }
        return zone;
    }

    @Override
    public void setDatabaseZone(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public void setJavaZone(ZoneOffset javaZone) {
        this.javaZone = javaZone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

