/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.sql.Date;
import java.util.TimeZone;
import org.jadira.usertype.dateandtime.threetenbp.columnmapper.AbstractDateThreeTenBPColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.temporal.TemporalAccessor;

public class DateColumnLocalDateMapper
extends AbstractDateThreeTenBPColumnMapper<LocalDate>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();

    public DateColumnLocalDateMapper() {
    }

    public DateColumnLocalDateMapper(ZoneOffset databaseZone) {
        super(databaseZone);
    }

    @Override
    public LocalDate fromNonNullString(String s) {
        return LocalDate.parse((CharSequence)s);
    }

    @Override
    public LocalDate fromNonNullValue(Date value) {
        if (this.getDatabaseZone() == null) {
            return LocalDate.parse((CharSequence)value.toString(), (DateTimeFormatter)LOCAL_DATE_FORMATTER);
        }
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnLocalDateMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime dateTime = ZonedDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)value.getTime()), (ZoneId)currentDatabaseZone);
        LocalDate localDate = dateTime.toLocalDate();
        return localDate;
    }

    @Override
    public String toNonNullString(LocalDate value) {
        return value.toString();
    }

    @Override
    public Date toNonNullValue(LocalDate value) {
        if (this.getDatabaseZone() == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.format((TemporalAccessor)value));
        }
        ZoneOffset currentDatabaseZone = this.getDatabaseZone() == null ? DateColumnLocalDateMapper.getDefault() : this.getDatabaseZone();
        ZonedDateTime zonedValue = value.atStartOfDay((ZoneId)currentDatabaseZone);
        Date date = new Date(zonedValue.toInstant().toEpochMilli());
        return date;
    }

    private static ZoneOffset getDefault() {
        ZoneOffset zone = null;
        try {
            try {
                String id = System.getProperty("user.timezone");
                if (id != null) {
                    zone = ZoneOffset.of((String)id);
                }
            }
            catch (RuntimeException ex) {
                zone = null;
            }
            if (zone == null) {
                zone = ZoneOffset.of((String)TimeZone.getDefault().getID());
            }
        }
        catch (RuntimeException ex) {
            zone = null;
        }
        if (zone == null) {
            zone = ZoneOffset.of((String)"Z");
        }
        return zone;
    }

    @Override
    public ZoneOffset parseZone(String zoneString) {
        return ZoneOffset.of((String)zoneString);
    }
}

