/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.math.BigInteger;
import org.jadira.usertype.spi.shared.AbstractBigIntegerColumnMapper;
import org.threeten.bp.Duration;

public class BigIntegerColumnDurationMapper
extends AbstractBigIntegerColumnMapper<Duration> {
    private static final long serialVersionUID = 8408450977695192938L;
    private static final BigInteger NANOS_IN_SECOND = BigInteger.valueOf(1000000000L);

    @Override
    public Duration fromNonNullString(String s) {
        return Duration.parse((CharSequence)s);
    }

    @Override
    public Duration fromNonNullValue(BigInteger value) {
        return Duration.ofSeconds((long)value.divide(NANOS_IN_SECOND).longValue(), (long)value.remainder(NANOS_IN_SECOND).longValue());
    }

    @Override
    public String toNonNullString(Duration value) {
        return value.toString();
    }

    @Override
    public BigInteger toNonNullValue(Duration value) {
        return BigInteger.valueOf(value.getNano()).add(BigInteger.valueOf(value.getSeconds()).multiply(NANOS_IN_SECOND));
    }
}

