/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threetenbp.columnmapper;

import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.jadira.usertype.spi.shared.AbstractDateColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeDateType;
import org.threeten.bp.ZoneOffset;

public abstract class AbstractDateThreeTenBPColumnMapper<T>
extends AbstractDateColumnMapper<T>
implements DatabaseZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = -7670411089210984705L;
    private ZoneOffset databaseZone = null;

    public AbstractDateThreeTenBPColumnMapper() {
    }

    public AbstractDateThreeTenBPColumnMapper(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public void setDatabaseZone(ZoneOffset databaseZone) {
        this.databaseZone = databaseZone;
    }

    protected ZoneOffset getDatabaseZone() {
        return this.databaseZone;
    }

    @Override
    public final DstSafeDateType getHibernateType() {
        if (this.databaseZone == null) {
            return DstSafeDateType.INSTANCE;
        }
        Calendar cal = this.resolveCalendar(this.databaseZone);
        if (cal == null) {
            throw new IllegalStateException("Could not map Zone " + this.databaseZone + " to Calendar");
        }
        return new DstSafeDateType(cal);
    }

    private Calendar resolveCalendar(ZoneOffset databaseZone) {
        String id = databaseZone.getId();
        if (Arrays.binarySearch(TimeZone.getAvailableIDs(), id) != -1) {
            return Calendar.getInstance(TimeZone.getTimeZone(id));
        }
        return null;
    }
}

