/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import java.util.Calendar;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimestampType;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

public class TimestampColumnInstantMapper
extends AbstractVersionableTimestampColumnMapper<Instant>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = -7670411089210984705L;
    private DateTimeZone databaseZone = DateTimeZone.UTC;

    public TimestampColumnInstantMapper() {
    }

    public TimestampColumnInstantMapper(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public Instant fromNonNullString(String s) {
        return new Instant(s);
    }

    @Override
    public Instant fromNonNullValue(Timestamp value) {
        Instant instant = new Instant(value.getTime());
        return instant;
    }

    @Override
    public String toNonNullString(Instant value) {
        return value.toString();
    }

    @Override
    public Timestamp toNonNullValue(Instant value) {
        Timestamp timestamp = new Timestamp(value.getMillis());
        return timestamp;
    }

    @Override
    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID(zoneString);
    }

    @Override
    public final DstSafeTimestampType getHibernateType() {
        return this.databaseZone == null ? DstSafeTimestampType.INSTANCE : new DstSafeTimestampType(Calendar.getInstance(this.databaseZone.toTimeZone()));
    }
}

