/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.TimeOfDay;
import org.joda.time.chrono.ISOChronology;

public class LongColumnTimeOfDayMapper
extends AbstractLongColumnMapper<TimeOfDay> {
    private static final long serialVersionUID = 8408450977695192938L;

    @Override
    public TimeOfDay fromNonNullString(String s) {
        return new TimeOfDay(s);
    }

    @Override
    public TimeOfDay fromNonNullValue(Long value) {
        return new TimeOfDay(value / 1000000L, (Chronology)ISOChronology.getInstance(DateTimeZone.UTC));
    }

    @Override
    public String toNonNullString(TimeOfDay value) {
        return value.toString();
    }

    @Override
    public Long toNonNullValue(TimeOfDay value) {
        return (long)value.toLocalTime().getMillisOfDay() * 1000000L;
    }
}

