/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import org.jadira.usertype.spi.shared.AbstractIntegerColumnMapper;
import org.joda.time.Duration;

public class IntegerColumnDurationMapper
extends AbstractIntegerColumnMapper<Duration> {
    private static final long serialVersionUID = 8408450977695192938L;

    @Override
    public Duration fromNonNullString(String s) {
        return new Duration(s);
    }

    @Override
    public Duration fromNonNullValue(Integer value) {
        return value == null ? new Duration(null) : Duration.millis(1000L * (long)value.intValue());
    }

    @Override
    public String toNonNullString(Duration value) {
        return value.toString();
    }

    @Override
    public Integer toNonNullValue(Duration value) {
        long longValue = value.getStandardSeconds();
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new IllegalStateException(longValue + " cannot be cast to int without changing its value.");
        }
        return (int)longValue;
    }
}

