/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.source.MappingDefaults;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class AnnotationBindingContextImpl
implements AnnotationBindingContext {
    private final MetadataImplementor metadata;
    private final ValueHolder<ClassLoaderService> classLoaderService;
    private final Index index;
    private final TypeResolver typeResolver = new TypeResolver();
    private final Map<Class<?>, ResolvedType> resolvedTypeCache = new HashMap();
    private Map<String, org.hibernate.metamodel.domain.Type> nameToJavaTypeMap = new HashMap<String, org.hibernate.metamodel.domain.Type>();

    public AnnotationBindingContextImpl(MetadataImplementor metadata, Index index) {
        this.metadata = metadata;
        this.classLoaderService = new ValueHolder<1>(new ValueHolder.DeferredInitializer<ClassLoaderService>(){

            @Override
            public ClassLoaderService initialize() {
                return AnnotationBindingContextImpl.this.metadata.getServiceRegistry().getService(ClassLoaderService.class);
            }
        });
        this.index = index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public ClassInfo getClassInfo(String name) {
        DotName dotName = DotName.createSimple(name);
        return this.index.getClassByName(dotName);
    }

    @Override
    public void resolveAllTypes(String className) {
        Class<Object> clazz = this.classLoaderService.getValue().classForName(className);
        ResolvedType resolvedType = this.typeResolver.resolve(clazz, new Type[0]);
        while (resolvedType != null) {
            this.resolvedTypeCache.put(clazz, resolvedType);
            if ((resolvedType = resolvedType.getParentClass()) == null) continue;
            clazz = resolvedType.getErasedType();
        }
    }

    @Override
    public ResolvedType getResolvedType(Class<?> clazz) {
        return this.resolvedTypeCache.get(clazz);
    }

    @Override
    public ResolvedTypeWithMembers resolveMemberTypes(ResolvedType type) {
        MemberResolver memberResolver = new MemberResolver(this.typeResolver);
        return memberResolver.resolve(type, null, null);
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.getMetadataImplementor().getServiceRegistry();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.metadata.getNamingStrategy();
    }

    @Override
    public MappingDefaults getMappingDefaults() {
        return this.metadata.getMappingDefaults();
    }

    @Override
    public MetadataImplementor getMetadataImplementor() {
        return this.metadata;
    }

    @Override
    public <T> Class<T> locateClassByName(String name) {
        return this.classLoaderService.getValue().classForName(name);
    }

    @Override
    public org.hibernate.metamodel.domain.Type makeJavaType(String className) {
        org.hibernate.metamodel.domain.Type javaType = this.nameToJavaTypeMap.get(className);
        if (javaType == null) {
            javaType = this.metadata.makeJavaType(className);
            this.nameToJavaTypeMap.put(className, javaType);
        }
        return javaType;
    }

    @Override
    public ValueHolder<Class<?>> makeClassReference(String className) {
        return new ValueHolder(this.locateClassByName(className));
    }

    @Override
    public String qualifyClassName(String name) {
        return name;
    }

    @Override
    public boolean isGloballyQuotedIdentifiers() {
        return this.metadata.isGloballyQuotedIdentifiers();
    }
}

