/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.node.POJONode;
import org.gluu.oxd.OxdHttpsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxd.client.CommandClient;
import org.xdi.oxd.client.CommandClientPool;
import org.xdi.oxd.common.Command;
import org.xdi.oxd.common.CommandResponse;
import org.xdi.oxd.common.CommandType;
import org.xdi.oxd.common.CoreUtils;
import org.xdi.oxd.common.ErrorResponse;
import org.xdi.oxd.common.params.GetAccessTokenByRefreshTokenParams;
import org.xdi.oxd.common.params.GetAuthorizationUrlParams;
import org.xdi.oxd.common.params.GetClientTokenParams;
import org.xdi.oxd.common.params.GetLogoutUrlParams;
import org.xdi.oxd.common.params.GetTokensByCodeParams;
import org.xdi.oxd.common.params.GetUserInfoParams;
import org.xdi.oxd.common.params.IParams;
import org.xdi.oxd.common.params.IntrospectAccessTokenParams;
import org.xdi.oxd.common.params.IntrospectRptParams;
import org.xdi.oxd.common.params.RegisterSiteParams;
import org.xdi.oxd.common.params.RemoveSiteParams;
import org.xdi.oxd.common.params.RpGetClaimsGatheringUrlParams;
import org.xdi.oxd.common.params.RpGetRptParams;
import org.xdi.oxd.common.params.RsCheckAccessParams;
import org.xdi.oxd.common.params.RsProtectParams;
import org.xdi.oxd.common.params.SetupClientParams;
import org.xdi.oxd.common.params.UpdateSiteParams;
import org.xdi.oxd.rs.protect.Jackson;

@Path(value="/")
public class RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RestResource.class);
    private final CommandClientPool pool;

    public RestResource(OxdHttpsConfiguration configuration) {
        this.pool = new CommandClientPool(configuration.getOxdConnectionExpirationInSeconds(), configuration.getOxdHost(), Integer.parseInt(configuration.getOxdPort()));
    }

    @GET
    @Path(value="/health-check")
    @Produces(value={"application/json"})
    public String healthCheck() {
        return "running";
    }

    @POST
    @Path(value="/setup-client")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String setupClient(String params) {
        return RestResource.response(this.send(CommandType.SETUP_CLIENT, RestResource.read(params, SetupClientParams.class)));
    }

    @POST
    @Path(value="/get-client-token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getClientToken(String params) {
        return RestResource.response(this.send(CommandType.GET_CLIENT_TOKEN, RestResource.read(params, GetClientTokenParams.class)));
    }

    @POST
    @Path(value="/introspect-access-token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String introspectAccessToken(String params) {
        IntrospectAccessTokenParams p = RestResource.read(params, IntrospectAccessTokenParams.class);
        return RestResource.response(this.send(CommandType.INTROSPECT_ACCESS_TOKEN, p));
    }

    @POST
    @Path(value="/introspect-rpt")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String introspectRpt(String params) {
        IntrospectRptParams p = RestResource.read(params, IntrospectRptParams.class);
        return RestResource.response(this.send(CommandType.INTROSPECT_RPT, p));
    }

    @POST
    @Path(value="/register-site")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String registerSite(@HeaderParam(value="Authorization") String authorization, String params) {
        RegisterSiteParams p = RestResource.read(params, RegisterSiteParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(authorization));
        return RestResource.response(this.send(CommandType.REGISTER_SITE, p));
    }

    @POST
    @Path(value="/update-site")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String updateSite(@HeaderParam(value="Authorization") String authorization, String params) {
        UpdateSiteParams p = RestResource.read(params, UpdateSiteParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(authorization));
        return RestResource.response(this.send(CommandType.UPDATE_SITE, p));
    }

    @POST
    @Path(value="/remove-site")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String removeSite(@HeaderParam(value="Authorization") String authorization, String params) {
        RemoveSiteParams p = RestResource.read(params, RemoveSiteParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(authorization));
        return RestResource.response(this.send(CommandType.REMOVE_SITE, p));
    }

    @POST
    @Path(value="/get-authorization-url")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getAuthorizationUrl(@HeaderParam(value="Authorization") String p_authorization, String params) {
        GetAuthorizationUrlParams p = RestResource.read(params, GetAuthorizationUrlParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.GET_AUTHORIZATION_URL, p));
    }

    @POST
    @Path(value="/get-tokens-by-code")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getTokenByCode(@HeaderParam(value="Authorization") String p_authorization, String params) {
        GetTokensByCodeParams p = RestResource.read(params, GetTokensByCodeParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.GET_TOKENS_BY_CODE, p));
    }

    @POST
    @Path(value="/get-user-info")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getUserInfo(@HeaderParam(value="Authorization") String p_authorization, String params) {
        GetUserInfoParams p = RestResource.read(params, GetUserInfoParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.GET_USER_INFO, p));
    }

    @POST
    @Path(value="/get-logout-uri")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getLogoutUri(@HeaderParam(value="Authorization") String p_authorization, String params) {
        GetLogoutUrlParams p = RestResource.read(params, GetLogoutUrlParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.GET_LOGOUT_URI, p));
    }

    @POST
    @Path(value="/get-access-token-by-refresh-token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getAccessTokenByRefreshToken(String params) {
        return RestResource.response(this.send(CommandType.GET_ACCESS_TOKEN_BY_REFRESH_TOKEN, RestResource.read(params, GetAccessTokenByRefreshTokenParams.class)));
    }

    @POST
    @Path(value="/uma-rs-protect")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String umaRsProtect(@HeaderParam(value="Authorization") String p_authorization, String params) {
        RsProtectParams p = RestResource.read(params, RsProtectParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.RS_PROTECT, p));
    }

    @POST
    @Path(value="/uma-rs-check-access")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String umaRsCheckAccess(@HeaderParam(value="Authorization") String p_authorization, String params) {
        RsCheckAccessParams p = RestResource.read(params, RsCheckAccessParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.RS_CHECK_ACCESS, p));
    }

    @POST
    @Path(value="/uma-rp-get-rpt")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String umaRpGetRpt(@HeaderParam(value="Authorization") String p_authorization, String params) {
        RpGetRptParams p = RestResource.read(params, RpGetRptParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(p_authorization));
        return RestResource.response(this.send(CommandType.RP_GET_RPT, p));
    }

    @POST
    @Path(value="/uma-rp-get-claims-gathering-url")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String umaRpGetClaimsGatheringUrl(@HeaderParam(value="Authorization") String authorization, String params) {
        RpGetClaimsGatheringUrlParams p = RestResource.read(params, RpGetClaimsGatheringUrlParams.class);
        p.setProtectionAccessToken(RestResource.validateAccessToken(authorization));
        return RestResource.response(this.send(CommandType.RP_GET_CLAIMS_GATHERING_URL, p));
    }

    public static <T> T read(String params, Class<T> clazz) {
        try {
            return Jackson.createJsonMapper().readValue(params, clazz);
        }
        catch (IOException e) {
            LOG.error("Invalid params: " + params, e);
            throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST).entity("Invalid parameters. Message: " + e.getMessage()).build());
        }
    }

    public static String response(CommandResponse commandResponse) {
        if (commandResponse == null) {
            LOG.error("Command response is null, please check oxd-server.log file of oxd-server application.");
            throw new WebApplicationException(Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("Command response is null, please check oxd-server.log file of oxd-server application.").build());
        }
        String json = CoreUtils.asJsonSilently(commandResponse);
        LOG.trace("Send back response: {}", (Object)json);
        return json;
    }

    public static String validateAccessToken(String authorizationParameter) {
        String accessToken;
        String prefix = "Bearer ";
        if (StringUtils.isNotEmpty(authorizationParameter) && authorizationParameter.startsWith("Bearer ") && StringUtils.isNotBlank(accessToken = authorizationParameter.substring("Bearer ".length()))) {
            return accessToken;
        }
        LOG.debug("No access token provided in Authorization header. Forbidden.");
        throw new WebApplicationException(RestResource.forbiddenErrorResponse(), Response.Status.FORBIDDEN);
    }

    public static String forbiddenErrorResponse() {
        ErrorResponse error = new ErrorResponse("403");
        error.setErrorDescription("Forbidden Access");
        CommandResponse commandResponse = CommandResponse.error().setData(new POJONode(error));
        return CoreUtils.asJsonSilently(commandResponse);
    }

    public CommandResponse send(CommandType commandType, IParams params) {
        CommandClient client = this.checkOut();
        try {
            LOG.trace("Command " + (Object)((Object)commandType) + " executed by client: " + client.getNameForLogger());
            CommandResponse response = client.send(new Command(commandType).setParamsObject(params));
            if (response != null) {
                this.pool.checkIn(client);
            } else {
                this.pool.expire(client);
            }
            return response;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.pool.expire(client);
            return null;
        }
    }

    private CommandClient checkOut() {
        CommandClient client = this.pool.checkOut();
        if (client == null) {
            LOG.error("Failed to initialize command client.");
            throw new WebApplicationException(Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("Command client is not able to connect to oxd-server.").build());
        }
        return client;
    }
}

