/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class UnknownControlFrameBodyParser
extends ControlFrameBodyParser {
    private final ControlFrameParser controlFrameParser;
    private State state = State.BODY;
    private int remaining;

    public UnknownControlFrameBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        switch (this.state) {
            case BODY: {
                this.remaining = this.controlFrameParser.getLength();
                this.state = State.CONSUME;
            }
            case CONSUME: {
                int consume = Math.min(this.remaining, buffer.remaining());
                buffer.position(buffer.position() + consume);
                this.remaining -= consume;
                if (this.remaining > 0) {
                    return false;
                }
                this.reset();
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void reset() {
        this.state = State.BODY;
        this.remaining = 0;
    }

    private static enum State {
        BODY,
        CONSUME;

    }
}

