/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.vagrant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandValidationErrors;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.Main;
import liquibase.sdk.TemplateService;
import liquibase.sdk.exception.UnexpectedLiquibaseSdkException;
import liquibase.sdk.supplier.database.ConnectionConfigurationFactory;
import liquibase.sdk.supplier.database.ConnectionSupplier;
import liquibase.util.StringUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class VagrantCommand
extends AbstractCommand {
    private final Main mainApp;
    private String vagrantPath;
    private String command;
    private VagrantInfo vagrantInfo;
    private CommandLine commandCommandLine;

    public VagrantCommand(Main mainApp) {
        this.mainApp = mainApp;
        this.vagrantPath = this.mainApp.getPath("vagrant.exe", "vagrant.bat", "vagrant.sh", "vagrant");
        if (this.vagrantPath == null) {
            throw new UnexpectedLiquibaseSdkException("Cannot find vagrant in " + mainApp.getPath());
        }
        mainApp.debug("Vagrant path: " + this.vagrantPath);
    }

    @Override
    public String getName() {
        return "vagrant";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public void setup(CommandLine commandCommandLine) throws Exception {
        List<String> commandArgs = commandCommandLine.getArgList();
        this.vagrantInfo = new VagrantInfo();
        if (commandArgs.size() < 2) {
            this.mainApp.fatal("Usage: liquibase-sdk vagrant BOX_NAME COMMAND");
        }
        this.vagrantInfo.boxName = commandArgs.get(0);
        this.command = commandArgs.get(1);
        this.vagrantInfo.vagrantRoot = new File(this.mainApp.getSdkRoot(), "vagrant");
        this.vagrantInfo.boxDir = new File(this.vagrantInfo.vagrantRoot, this.vagrantInfo.boxName).getCanonicalFile();
        this.commandCommandLine = commandCommandLine;
    }

    @Override
    protected Object run() throws Exception {
        if (this.command.equals("init")) {
            this.init();
        } else if (this.command.equals("up")) {
            this.up();
        } else if (this.command.equals("provision")) {
            this.provision();
        } else if (this.command.equals("destroy")) {
            this.destroy();
        } else if (this.command.equals("halt")) {
            this.halt();
        } else if (this.command.equals("reload")) {
            this.reload();
        } else if (this.command.equals("resume")) {
            this.resume();
        } else if (this.command.equals("status")) {
            this.status();
        } else if (this.command.equals("suspend")) {
            this.suspend();
        } else {
            this.mainApp.fatal("Unknown vagrant command '" + this.command + "'");
        }
        return "Successful";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        if (!this.commandCommandLine.hasOption("databases")) {
            this.mainApp.fatal("vagrant init requires --databases option");
        }
        String[] databaseConfigs = this.commandCommandLine.getOptionValue("databases").split("\\s*,\\s*");
        this.mainApp.out("Vagrant Machine Setup:");
        this.mainApp.out(StringUtils.indent("Vagrant Box Name: " + this.vagrantInfo.boxName));
        this.mainApp.out(StringUtils.indent("Local Path: " + this.vagrantInfo.boxDir.getAbsolutePath()));
        this.mainApp.out(StringUtils.indent("Database Config(s): " + StringUtils.join(databaseConfigs, ", ")));
        Collection<ConnectionSupplier> databases = null;
        try {
            databases = ConnectionConfigurationFactory.getInstance().findConfigurations(databaseConfigs);
        }
        catch (ConnectionConfigurationFactory.UnknownDatabaseException e) {
            this.mainApp.fatal(e);
        }
        for (ConnectionSupplier connectionConfig : databases) {
            if (this.vagrantInfo.baseBoxName == null) {
                this.vagrantInfo.baseBoxName = connectionConfig.getVagrantBaseBoxName();
            } else if (!this.vagrantInfo.baseBoxName.equals(connectionConfig.getVagrantBaseBoxName())) {
                throw new UnexpectedLiquibaseException("Configuration " + connectionConfig + " needs vagrant box " + connectionConfig.getVagrantBaseBoxName() + ", not " + this.vagrantInfo.baseBoxName + " like other configurations");
            }
            if (this.vagrantInfo.ipAddress == null) {
                this.vagrantInfo.ipAddress = connectionConfig.getIpAddress();
                continue;
            }
            if (this.vagrantInfo.ipAddress.equals(connectionConfig.getIpAddress())) continue;
            throw new UnexpectedLiquibaseException("Configuration " + connectionConfig + " does not match previously defined hostname " + this.vagrantInfo.ipAddress);
        }
        this.mainApp.out(StringUtils.indent("Vagrant Base Box: " + this.vagrantInfo.baseBoxName));
        this.mainApp.out(StringUtils.indent("IP Address: " + this.vagrantInfo.ipAddress));
        Properties liquibaseVagrantProperties = new Properties();
        liquibaseVagrantProperties.put("box.ipaddress", this.vagrantInfo.ipAddress);
        liquibaseVagrantProperties.put("box.base", this.vagrantInfo.boxName);
        this.mainApp.out("");
        int i = 0;
        for (ConnectionSupplier config : databases) {
            this.mainApp.out("Database Configuration For '" + config.toString() + "':");
            this.mainApp.out(StringUtils.indent(config.getDescription()));
            this.mainApp.out("");
            this.addVagrantConfigProperty(i, "supplier", config.toString(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "shortName", config.getDatabaseShortName(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "version", config.getVersion(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "jdbcUrl", config.getJdbcUrl(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "adminUsername", config.getAdminUsername(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "adminPassword", config.getAdminPassword(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "primaryCatalog", config.getPrimaryCatalog(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "primarySchema", config.getPrimarySchema(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "altCatalog", config.getAlternateCatalog(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "altSchema", config.getAlternateSchema(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "username", config.getDatabaseUsername(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "password", config.getDatabasePassword(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "altUsername", config.getAlternateUsername(), liquibaseVagrantProperties);
            this.addVagrantConfigProperty(i, "altPassword", config.getAlternateUserPassword(), liquibaseVagrantProperties);
        }
        this.writeVagrantFile(this.vagrantInfo);
        this.writePuppetFiles(this.vagrantInfo, databases);
        this.writeConfigFiles(this.vagrantInfo, databases);
        HashSet<String> propertiesFiles = new HashSet<String>();
        for (ConnectionSupplier connectionSupplier : databases) {
            String fileName = "liquibase." + this.vagrantInfo.boxDir.getName() + "-" + connectionSupplier.getDatabaseShortName() + ".properties";
            String propertiesFile = "### Connection Property File For Vagrant Box '" + this.vagrantInfo.boxName + "'\n" + "### Example use: .." + File.separator + ".." + File.separator + "liquibase --defaultsFile=" + fileName + " update\n\n" + "classpath: changelog\n" + "changeLogFile=com/example/changelog.xml\n" + "username=" + connectionSupplier.getDatabaseUsername() + "\n" + "password=" + connectionSupplier.getDatabaseUsername() + "\n" + "url=" + connectionSupplier.getJdbcUrl() + "\n" + "#logLevel=DEBUG\n" + "#referenceUrl=" + connectionSupplier.getJdbcUrl() + "\n" + "#referenceUsername=" + connectionSupplier.getDatabaseUsername() + "\n" + "#referencePassword=" + connectionSupplier.getDatabasePassword() + "\n";
            fileName = "workspace/" + fileName;
            File propertyFile = new File(this.mainApp.getSdkRoot(), fileName);
            if (propertyFile.exists()) {
                this.mainApp.out("NOTE: Not overwriting existing workspace properties file " + propertyFile.getAbsolutePath());
            } else {
                FileWriter writer = new FileWriter(propertyFile);
                try {
                    writer.write(propertiesFile);
                }
                finally {
                    writer.flush();
                    writer.close();
                }
                propertiesFiles.add(fileName);
            }
            FileOutputStream vagrantPropertiesStream = new FileOutputStream(new File(this.vagrantInfo.boxDir, "liquibase.vagrant.properties"));
            try {
                liquibaseVagrantProperties.store(vagrantPropertiesStream, "Original configuration for vagrant box " + this.vagrantInfo.boxDir.getName());
            }
            finally {
                vagrantPropertiesStream.flush();
                vagrantPropertiesStream.close();
            }
        }
        this.mainApp.out("Vagrant Box " + this.vagrantInfo.boxName + " created. To start the box, run 'liquibase-sdk vagrant " + this.vagrantInfo.boxName + "' up");
        if (propertiesFiles.size() > 0) {
            this.mainApp.out("Created workspace properties file(s): " + StringUtils.join(propertiesFiles, ", "));
        }
        this.mainApp.out("Make sure any needed JDBC drivers are added to LIQUIBASE_HOME/lib");
        this.mainApp.out("NOTE: If you do not already have a vagrant box called " + this.vagrantInfo.baseBoxName + " installed, run 'vagrant box add " + this.vagrantInfo.baseBoxName + " VALID_URL'");
    }

    protected void addVagrantConfigProperty(int index, String name, Object value, Properties properties) {
        if (value != null) {
            properties.put("database." + index + "." + name, value);
        }
    }

    public void provision() {
        this.runVagrant(this.vagrantInfo, "provision");
    }

    public void destroy() {
        this.runVagrant(this.vagrantInfo, "destroy", "--force");
    }

    public void halt() {
        this.runVagrant(this.vagrantInfo, "halt");
    }

    public void reload() {
        this.runVagrant(this.vagrantInfo, "reload");
    }

    public void resume() {
        this.runVagrant(this.vagrantInfo, "resume");
    }

    public void status() {
        this.runVagrant(this.vagrantInfo, "status");
    }

    public void suspend() {
        this.runVagrant(this.vagrantInfo, "suspend");
    }

    public void up() {
        this.mainApp.out("Starting vagrant in " + this.vagrantInfo.boxDir.getAbsolutePath());
        this.mainApp.out("Config Name: " + this.vagrantInfo.boxName);
        this.mainApp.divider();
        this.runVagrant(this.vagrantInfo, "up");
    }

    private void runVagrant(VagrantInfo vagrantInfo, String ... arguments) {
        if (!vagrantInfo.boxDir.exists()) {
            this.mainApp.fatal("Vagrant box directory " + vagrantInfo.boxDir.getAbsolutePath() + " does not exist");
        }
        ArrayList<String> finalArguments = new ArrayList<String>();
        finalArguments.add(this.vagrantPath);
        finalArguments.addAll(Arrays.asList(arguments));
        ProcessBuilder processBuilder = new ProcessBuilder(finalArguments.toArray(new String[finalArguments.size()]));
        processBuilder.directory(vagrantInfo.boxDir);
        Map<String, String> env = processBuilder.environment();
        processBuilder.redirectErrorStream(true);
        int out = 0;
        try {
            Process process = processBuilder.start();
            InputStream is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.mainApp.out(line);
            }
            out = process.exitValue();
        }
        catch (Exception e) {
            this.mainApp.out("Error running vagrant");
            e.printStackTrace();
        }
        if (out != 0) {
            this.mainApp.out("Error running Vagrant. Return code " + out);
        }
    }

    private void writePuppetFiles(VagrantInfo vagrantInfo, Collection<ConnectionSupplier> databases) throws Exception {
        this.copyFile("liquibase/sdk/vagrant/shell/bootstrap.sh", new File(vagrantInfo.boxDir, "shell")).setExecutable(true);
        this.copyFile("liquibase/sdk/vagrant/shell/bootstrap.bat", new File(vagrantInfo.boxDir, "shell")).setExecutable(true);
        this.writePuppetFile(vagrantInfo, databases);
        this.writeManifestsInit(vagrantInfo, databases);
        File modulesDir = new File(vagrantInfo.boxDir, "modules");
        this.copyFile("liquibase/sdk/vagrant/modules/my_firewall/manifests/pre.pp", new File(modulesDir, "my_firewall/manifests"));
        this.copyFile("liquibase/sdk/vagrant/modules/my_firewall/manifests/post.pp", new File(modulesDir, "my_firewall/manifests"));
    }

    private void writePuppetFile(VagrantInfo vagrantInfo, Collection<ConnectionSupplier> databases) throws Exception {
        HashSet<String> forges = new HashSet<String>();
        HashSet<String> modules = new HashSet<String>();
        for (ConnectionSupplier config : databases) {
            forges.addAll(config.getPuppetForges(vagrantInfo.boxName));
            modules.addAll(config.getPuppetModules());
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("puppetForges", forges);
        context.put("puppetModules", modules);
        TemplateService.getInstance().write("liquibase/sdk/vagrant/Puppetfile.vm", new File(vagrantInfo.boxDir, "Puppetfile"), context);
    }

    private void writeManifestsInit(VagrantInfo vagrantInfo, Collection<ConnectionSupplier> databases) throws Exception {
        String osLevelConfig;
        File manifestsDir = new File(vagrantInfo.boxDir, "manifests");
        manifestsDir.mkdirs();
        HashSet<String> puppetBlocks = new HashSet<String>();
        for (ConnectionSupplier config : databases) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("supplier", config);
            ConnectionSupplier.ConfigTemplate thisInit = config.getPuppetTemplate(context);
            if (thisInit == null) continue;
            puppetBlocks.add(thisInit.output());
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("puppetBlocks", puppetBlocks);
        if (vagrantInfo.baseBoxName.contains("linux")) {
            osLevelConfig = "service { \"iptables\":\n  enable => false,\n  ensure => \"stopped\",\n}\n\n";
            HashSet<String> requiredPackages = new HashSet<String>();
            requiredPackages.add("unzip");
            for (ConnectionSupplier config : databases) {
                requiredPackages.addAll(config.getRequiredPackages(vagrantInfo.boxName));
            }
            for (String requiredPackage : requiredPackages) {
                osLevelConfig = osLevelConfig + "package { \"" + requiredPackage + "\":\n" + "    ensure => \"installed\"\n" + "}\n\n";
            }
        } else {
            osLevelConfig = "package { '7zip':\n    ensure  => '9.20',\n    source\t=>\t\"http://downloads.sourceforge.net/sevenzip/7z920-x64.msi\",\n}\n";
        }
        context.put("osLevelConfig", osLevelConfig);
        TemplateService.getInstance().write("liquibase/sdk/vagrant/manifests/init.pp.vm", new File(manifestsDir, "init.pp"), context);
    }

    private File copyFile(String sourcePath, File outputDir) throws Exception {
        String line;
        outputDir.mkdirs();
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(sourcePath);
        if (input == null) {
            throw new UnexpectedLiquibaseSdkException("Missing source file: " + sourcePath);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String fileName = sourcePath.replaceFirst(".*/", "");
        File file = new File(outputDir, fileName);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        while ((line = reader.readLine()) != null) {
            output.write(line + "\n");
        }
        output.flush();
        output.close();
        return file;
    }

    private void writeVagrantFile(VagrantInfo vagrantInfo) throws Exception {
        String shellScript;
        String osLevelConfig;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("configVmBox", vagrantInfo.baseBoxName);
        context.put("configVmNetworkIp", vagrantInfo.ipAddress);
        context.put("vmCustomizeMemory", "8192");
        if (vagrantInfo.baseBoxName.contains("windows")) {
            osLevelConfig = "config.vm.communicator = \"winrm\"\n";
            shellScript = "shell/bootstrap.bat";
        } else {
            shellScript = "shell/bootstrap.sh";
            osLevelConfig = "";
        }
        context.put("osLevelConfig", StringUtils.indent(osLevelConfig, 4));
        context.put("configVmProvisionScript", shellScript);
        TemplateService.getInstance().write("liquibase/sdk/vagrant/Vagrantfile.vm", new File(vagrantInfo.boxDir, "Vagrantfile"), context);
    }

    private void writeConfigFiles(VagrantInfo vagrantInfo, Collection<ConnectionSupplier> databases) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (ConnectionSupplier config : databases) {
            context.put("supplier", config);
            Set<ConnectionSupplier.ConfigTemplate> configTemplates = config.generateConfigFiles(context);
            if (configTemplates == null) continue;
            for (ConnectionSupplier.ConfigTemplate configTemplate : configTemplates) {
                File outputFile = new File(vagrantInfo.boxDir + "/modules/conf/" + config.getDatabaseShortName(), configTemplate.getOutputFileName());
                outputFile.getParentFile().mkdirs();
                configTemplate.write(outputFile);
            }
        }
    }

    public Options getOptions() {
        Option databases = new Option("databases", true, "Database configurations");
        return new Options().addOption(databases);
    }

    private static final class VagrantInfo {
        public String boxName;
        private File vagrantRoot;
        private File boxDir;
        private String baseBoxName;
        private String ipAddress;

        private VagrantInfo() {
        }
    }
}

