/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import liquibase.command.AbstractCommand;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.LogLevel;
import liquibase.sdk.Context;
import liquibase.sdk.convert.ConvertCommand;
import liquibase.sdk.vagrant.VagrantCommand;
import liquibase.sdk.watch.WatchCommand;
import liquibase.util.StringUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;

public class Main {
    private boolean debug = false;
    private CommandLine globalArguments;
    private String command;
    private List<String> commandArgs = new ArrayList<String>();
    private Options globalOptions = new Options();

    public static void main(String[] args) {
        Main main = new Main();
        main.header("Liquibase SDK");
        try {
            AbstractCommand command;
            main.init(args);
            if (main.command == null) {
                throw new UserError("No command passed");
            }
            if (main.command.equals("help")) {
                main.printHelp();
                return;
            }
            GnuParser commandParser = new GnuParser();
            if (main.command.equals("vagrant")) {
                command = new VagrantCommand(main);
                try {
                    CommandLine commandArguments = commandParser.parse(((VagrantCommand)command).getOptions(), main.commandArgs.toArray(new String[main.commandArgs.size()]));
                    ((VagrantCommand)command).setup(commandArguments);
                }
                catch (ParseException e) {
                    throw new UserError("Error parsing command arguments: " + e.getMessage());
                }
            } else if (main.command.equals("watch")) {
                ((StdErrLog)Log.getRootLogger()).setLevel(3);
                LogFactory.getInstance().setDefaultLoggingLevel(LogLevel.WARNING);
                command = new WatchCommand(main);
                Options options = new Options();
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Webserver port. Default 8080");
                options.addOption(OptionBuilder.create("port"));
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Database URL");
                OptionBuilder.isRequired();
                options.addOption(OptionBuilder.create("url"));
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Database username");
                OptionBuilder.isRequired();
                options.addOption(OptionBuilder.create("username"));
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Database password");
                OptionBuilder.isRequired();
                options.addOption(OptionBuilder.create("password"));
                CommandLine commandArguments = commandParser.parse(options, main.commandArgs.toArray(new String[main.commandArgs.size()]));
                ((WatchCommand)command).setUrl(commandArguments.getOptionValue("url"));
                ((WatchCommand)command).setUsername(commandArguments.getOptionValue("username"));
                ((WatchCommand)command).setPassword(commandArguments.getOptionValue("password"));
                if (commandArguments.hasOption("port")) {
                    ((WatchCommand)command).setPort(Integer.valueOf(commandArguments.getOptionValue("port")));
                }
            } else if (main.command.equals("convert")) {
                command = new ConvertCommand(main);
                Options options = new Options();
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Original changelog");
                OptionBuilder.isRequired();
                options.addOption(OptionBuilder.create("src"));
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Output changelog");
                OptionBuilder.isRequired();
                options.addOption(OptionBuilder.create("out"));
                OptionBuilder.hasArg();
                OptionBuilder.withDescription("Classpath");
                options.addOption(OptionBuilder.create("classpath"));
                CommandLine commandArguments = commandParser.parse(options, main.commandArgs.toArray(new String[main.commandArgs.size()]));
                ((ConvertCommand)command).setSrc(commandArguments.getOptionValue("src"));
                ((ConvertCommand)command).setOut(commandArguments.getOptionValue("out"));
                ((ConvertCommand)command).setClasspath(commandArguments.getOptionValue("classpath"));
            } else {
                throw new UserError("Unknown command: " + main.command);
            }
            command.execute();
            main.divider();
            main.out("Command executed successfully");
        }
        catch (UserError userError) {
            main.out("");
            main.header("ERROR EXECUTING COMMAND");
            main.out(userError.getMessage());
            main.out("");
            main.out("");
            return;
        }
        catch (Throwable exception) {
            System.out.println("Unexpected error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void init(String[] args) throws UserError {
        Context.reset();
        GnuParser globalParser = new GnuParser();
        ArrayList<String> globalArgs = new ArrayList<String>();
        boolean inGlobal = true;
        for (String arg : args) {
            if (inGlobal) {
                if (arg.startsWith("--")) {
                    globalArgs.add(arg);
                    continue;
                }
                this.command = arg;
                inGlobal = false;
                continue;
            }
            this.commandArgs.add(arg);
        }
        try {
            this.globalArguments = globalParser.parse(this.globalOptions, globalArgs.toArray(new String[globalArgs.size()]));
        }
        catch (ParseException e) {
            throw new UserError("Error parsing global command line argument: " + e.getMessage());
        }
    }

    public File getSdkRoot() {
        for (File dir = new File(".").getAbsoluteFile(); dir != null; dir = dir.getParentFile()) {
            if (dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals("liquibase-sdk.bat");
                }
            }).length <= 0) continue;
            return dir;
        }
        throw new UnexpectedLiquibaseException("Could not find Liquibase SDK home. Please run liquibase-sdk from the liquibase/sdk directory or one of it's sub directories");
    }

    public String getCommand() {
        return this.command;
    }

    public void header(String ... header) {
        this.divider();
        for (String line : header) {
            System.out.println(line);
        }
        this.divider();
    }

    public void divider() {
        System.out.println("---------------------------------------------------");
    }

    public void out(String message) {
        System.out.println(message);
    }

    public void debug(String message) {
        if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    public void fatal(String error) throws UserError {
        throw new UserError(error);
    }

    public void fatal(Throwable exception) {
        this.fatal(exception.getMessage(), exception);
    }

    public void fatal(String error, Throwable exception) throws UserError {
        throw new UserError(error, exception);
    }

    public String getPath() {
        Map<String, String> environment = new ProcessBuilder(new String[0]).environment();
        String path = environment.get("Path");
        if (path == null) {
            path = environment.get("PATH");
        }
        if (path == null) {
            path = environment.get("path");
        }
        if (path == null) {
            throw new UnexpectedLiquibaseException("Cannot find path variable in environment. Possible variables are " + StringUtils.join(environment.keySet(), ","));
        }
        return path;
    }

    public String getPath(String ... possibleFileNames) {
        HashSet fileNames = new HashSet();
        for (String dir : this.getPath().split("[:;]")) {
            for (String fileName : possibleFileNames) {
                File file = new File(dir, fileName);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("liquibase-sdk [global options] [command] [command options]", this.globalOptions);
    }

    private static class UserError
    extends RuntimeException {
        public UserError(String message) {
            super(message);
        }

        UserError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

