/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import liquibase.Liquibase;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.ant.logging.AntTaskLogFactory;
import liquibase.integration.ant.type.ChangeLogParametersType;
import liquibase.integration.ant.type.DatabaseType;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.ui.UIFactory;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseLiquibaseTask
extends Task {
    private AntClassLoader classLoader;
    private Liquibase liquibase;
    private Path classpath;
    private DatabaseType databaseType;
    private ChangeLogParametersType changeLogParameters;
    private boolean promptOnNonLocalDatabase = false;

    public void init() throws BuildException {
        LogFactory.setInstance(new AntTaskLogFactory(this));
        this.classpath = new Path(this.getProject());
    }

    public final void execute() throws BuildException {
        Database database;
        block7: {
            super.execute();
            this.log("Starting Liquibase.", 2);
            this.classLoader = this.getProject().createClassLoader(this.classpath);
            this.classLoader.setParent(((Object)((Object)this)).getClass().getClassLoader());
            this.classLoader.setThreadContextLoader();
            this.validateParameters();
            database = null;
            ResourceAccessor resourceAccessor = this.createResourceAccessor((ClassLoader)this.classLoader);
            database = this.createDatabaseFromType(this.databaseType);
            this.liquibase = new Liquibase(this.getChangeLogFile(), resourceAccessor, database);
            if (this.changeLogParameters != null) {
                this.changeLogParameters.applyParameters(this.liquibase);
            }
            if (!this.isPromptOnNonLocalDatabase() || this.liquibase.isSafeToRunUpdate() || !UIFactory.getInstance().getFacade().promptForNonLocalDatabase(this.liquibase.getDatabase())) break block7;
            this.log("User chose not to run task against a non-local database.", 2);
            this.closeDatabase(database);
            this.classLoader.resetThreadContextLoader();
            this.classLoader.cleanup();
            this.classLoader = null;
            return;
        }
        try {
            if (this.shouldRun()) {
                this.executeWithLiquibaseClassloader();
            }
            this.closeDatabase(database);
        }
        catch (LiquibaseException e) {
            try {
                throw new BuildException("Unable to initialize Liquibase. " + e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDatabase(database);
                this.classLoader.resetThreadContextLoader();
                this.classLoader.cleanup();
                this.classLoader = null;
                throw throwable;
            }
        }
        this.classLoader.resetThreadContextLoader();
        this.classLoader.cleanup();
        this.classLoader = null;
    }

    protected abstract void executeWithLiquibaseClassloader() throws BuildException;

    protected Database createDatabaseFromType(DatabaseType databaseType) {
        return databaseType.createDatabase((ClassLoader)this.classLoader);
    }

    protected Liquibase getLiquibase() {
        return this.liquibase;
    }

    protected String getChangeLogFile() {
        return null;
    }

    protected boolean shouldRun() {
        LiquibaseConfiguration configuration = LiquibaseConfiguration.getInstance();
        GlobalConfiguration globalConfiguration = configuration.getConfiguration(GlobalConfiguration.class);
        if (!globalConfiguration.getShouldRun()) {
            this.log("Liquibase did not run because " + configuration.describeValueLookupLogic(globalConfiguration.getProperty("shouldRun")) + " was set to false", 2);
            return false;
        }
        return true;
    }

    protected String getDefaultOutputEncoding() {
        LiquibaseConfiguration liquibaseConfiguration = LiquibaseConfiguration.getInstance();
        GlobalConfiguration globalConfiguration = liquibaseConfiguration.getConfiguration(GlobalConfiguration.class);
        return globalConfiguration.getOutputEncoding();
    }

    protected void validateParameters() {
        if (this.databaseType == null) {
            throw new BuildException("A database or databaseref is required.");
        }
    }

    private ResourceAccessor createResourceAccessor(ClassLoader classLoader) {
        FileSystemResourceAccessor fileSystemResourceAccessor = new FileSystemResourceAccessor();
        ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(classLoader);
        return new CompositeResourceAccessor(fileSystemResourceAccessor, classLoaderResourceAccessor);
    }

    private void closeDatabase(Database database) {
        try {
            if (database != null) {
                database.close();
            }
        }
        catch (DatabaseException e) {
            this.log("Error closing the database connection.", e, 1);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addDatabase(DatabaseType databaseType) {
        if (this.databaseType != null) {
            throw new BuildException("Only one <database> element is allowed.");
        }
        this.databaseType = databaseType;
    }

    public void setDatabaseRef(Reference databaseRef) {
        this.databaseType = new DatabaseType(this.getProject());
        this.databaseType.setRefid(databaseRef);
    }

    public void addChangeLogParameters(ChangeLogParametersType changeLogParameters) {
        if (this.changeLogParameters != null) {
            throw new BuildException("Only one <changeLogParameters> element is allowed.");
        }
        this.changeLogParameters = changeLogParameters;
    }

    public void setChangeLogParametersRef(Reference changeLogParametersRef) {
        this.changeLogParameters = new ChangeLogParametersType(this.getProject());
        this.changeLogParameters.setRefid(changeLogParametersRef);
    }

    public boolean isPromptOnNonLocalDatabase() {
        return this.promptOnNonLocalDatabase;
    }

    public void setPromptOnNonLocalDatabase(boolean promptOnNonLocalDatabase) {
        this.promptOnNonLocalDatabase = promptOnNonLocalDatabase;
    }

    private DatabaseType getDatabaseType() {
        if (this.databaseType == null) {
            this.databaseType = new DatabaseType(this.getProject());
        }
        return this.databaseType;
    }

    private ChangeLogParametersType getChangeLogParametersType() {
        if (this.changeLogParameters == null) {
            this.changeLogParameters = new ChangeLogParametersType(this.getProject());
        }
        return this.changeLogParameters;
    }

    @Deprecated
    public String getDriver() {
        return this.getDatabaseType().getDriver();
    }

    @Deprecated
    public void setDriver(String driver) {
        this.log("The driver attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setDriver(driver);
    }

    @Deprecated
    public String getUrl() {
        return this.getDatabaseType().getUrl();
    }

    @Deprecated
    public void setUrl(String url) {
        this.log("The url attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setUrl(url);
    }

    @Deprecated
    public String getUsername() {
        return this.getDatabaseType().getUser();
    }

    @Deprecated
    public void setUsername(String username) {
        this.log("The username attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setUser(username);
    }

    @Deprecated
    public String getPassword() {
        return this.getDatabaseType().getPassword();
    }

    @Deprecated
    public void setPassword(String password) {
        this.log("The password attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setPassword(password);
    }

    public void setChangeLogFile(String changeLogFile) {
    }

    @Deprecated
    public String getCurrentDateTimeFunction() {
        return this.getDatabaseType().getCurrentDateTimeFunction();
    }

    @Deprecated
    public void setCurrentDateTimeFunction(String currentDateTimeFunction) {
        this.log("The currentDateTimeFunction attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setCurrentDateTimeFunction(currentDateTimeFunction);
    }

    public FileResource getOutputFile() {
        return null;
    }

    public void setOutputFile(FileResource outputFile) {
    }

    @Deprecated
    public Writer createOutputWriter() throws IOException {
        if (this.getOutputFile() == null) {
            return null;
        }
        GlobalConfiguration globalConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
        String encoding = globalConfiguration.getOutputEncoding();
        return new OutputStreamWriter(this.getOutputFile().getOutputStream(), encoding);
    }

    @Deprecated
    public PrintStream createPrintStream() throws IOException {
        if (this.getOutputFile() == null) {
            return null;
        }
        GlobalConfiguration globalConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
        String encoding = globalConfiguration.getOutputEncoding();
        return new PrintStream(this.getOutputFile().getOutputStream(), false, encoding);
    }

    public void setOutputEncoding(String outputEncoding) {
    }

    @Deprecated
    public String getDefaultCatalogName() {
        return this.getDatabaseType().getDefaultCatalogName();
    }

    @Deprecated
    public void setDefaultCatalogName(String defaultCatalogName) {
        this.log("The defaultCatalogName attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setDefaultCatalogName(defaultCatalogName);
    }

    @Deprecated
    public String getDefaultSchemaName() {
        return this.getDatabaseType().getDefaultSchemaName();
    }

    @Deprecated
    public void setDefaultSchemaName(String defaultSchemaName) {
        this.log("The driver attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setDefaultSchemaName(defaultSchemaName);
    }

    @Deprecated
    public void addConfiguredChangeLogProperty(ChangeLogProperty changeLogProperty) {
        this.log("The <changeLogProperty> element is deprecated. Use a nested <changeLogParameters> element instead.", 1);
        Property property = new Property();
        property.setName(changeLogProperty.getName());
        property.setValue(changeLogProperty.getValue());
        this.getChangeLogParametersType().addConfiguredChangeLogParameter(property);
    }

    @Deprecated
    protected Liquibase createLiquibase() throws Exception {
        return this.liquibase;
    }

    @Deprecated
    protected Database createDatabaseObject(String driverClassName, String databaseUrl, String username, String password, String defaultCatalogName, String defaultSchemaName, String databaseClass) throws Exception {
        return this.createDatabaseFromType(this.databaseType);
    }

    public String getContexts() {
        return null;
    }

    public void setContexts(String cntx) {
    }

    @Deprecated
    protected void closeDatabase(Liquibase liquibase) {
        if (liquibase != null && liquibase.getDatabase() != null && liquibase.getDatabase().getConnection() != null) {
            try {
                liquibase.getDatabase().close();
            }
            catch (DatabaseException e) {
                this.log("Error closing database: " + e.getMessage());
            }
        }
    }

    @Deprecated
    public String getDatabaseClass() {
        return this.getDatabaseType().getDatabaseClass();
    }

    @Deprecated
    public void setDatabaseClass(String databaseClass) {
        this.log("The databaseClass attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setDatabaseClass(databaseClass);
    }

    @Deprecated
    public String getDatabaseChangeLogTableName() {
        return this.getDatabaseType().getDatabaseChangeLogTableName();
    }

    @Deprecated
    public void setDatabaseChangeLogTableName(String tableName) {
        this.log("The databaseChangeLogTableName attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setDatabaseChangeLogTableName(tableName);
    }

    @Deprecated
    public String getDatabaseChangeLogLockTableName() {
        return this.getDatabaseType().getDatabaseChangeLogLockTableName();
    }

    @Deprecated
    public void setDatabaseChangeLogLockTableName(String tableName) {
        this.log("The databaseChangeLogLockTableName attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.databaseType.setDatabaseChangeLogLockTableName(tableName);
    }

    @Deprecated
    public String getDatabaseChangeLogObjectsTablespace() {
        return this.databaseType.getLiquibaseTablespaceName();
    }

    @Deprecated
    public void setDatabaseChangeLogObjectsTablespace(String tablespaceName) {
        this.log("The databaseChangeLogObjectsTablespace attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setLiquibaseTablespaceName(tablespaceName);
    }

    @Deprecated
    public boolean isOutputDefaultSchema() {
        return this.getDatabaseType().isOutputDefaultSchema();
    }

    @Deprecated
    public void setOutputDefaultSchema(boolean outputDefaultSchema) {
        this.log("The outputDefaultSchema attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setOutputDefaultSchema(outputDefaultSchema);
    }

    @Deprecated
    public boolean isOutputDefaultCatalog() {
        return this.getDatabaseType().isOutputDefaultCatalog();
    }

    @Deprecated
    public void setOutputDefaultCatalog(boolean outputDefaultCatalog) {
        this.log("The outputDefaultCatalog attribute is deprecated. Use a nested <database> element or set the databaseRef attribute instead.", 1);
        this.getDatabaseType().setOutputDefaultCatalog(outputDefaultCatalog);
    }

    @Deprecated
    public String getLogLevel() {
        return LogFactory.getInstance().getLog().getLogLevel().name();
    }

    @Deprecated
    public void setLogLevel(String level) {
        LogFactory.getInstance().getLog().setLogLevel(level);
    }

    @Deprecated
    public static class ChangeLogProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @Deprecated
    protected static class LogRedirector {
        private final Task task;

        protected LogRedirector(Task task) {
            this.task = task;
        }

        protected void redirectLogger() {
            this.registerHandler(this.createHandler());
        }

        protected void registerHandler(Handler theHandler) {
            Logger logger2 = LogFactory.getInstance().getLog();
        }

        protected Handler createHandler() {
            return new Handler(){

                @Override
                public void publish(LogRecord logRecord) {
                    LogRedirector.this.task.log(logRecord.getMessage(), this.mapLevelToAntLevel(logRecord.getLevel()));
                }

                @Override
                public void close() throws SecurityException {
                }

                @Override
                public void flush() {
                }

                protected int mapLevelToAntLevel(Level level) {
                    if (Level.ALL == level) {
                        return 2;
                    }
                    if (Level.SEVERE == level) {
                        return 0;
                    }
                    if (Level.WARNING == level) {
                        return 1;
                    }
                    if (Level.INFO == level) {
                        return 2;
                    }
                    return 3;
                }
            };
        }
    }
}

