/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.views.View;
import io.dropwizard.views.ViewRenderer;
import io.dropwizard.views.mustache.PerClassMustacheResolver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;

public class MustacheViewRenderer
implements ViewRenderer {
    private final LoadingCache<Class<? extends View>, MustacheFactory> factories = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends View>, MustacheFactory>(){

        @Override
        public MustacheFactory load(Class<? extends View> key) throws Exception {
            return new DefaultMustacheFactory(new PerClassMustacheResolver(key));
        }
    });

    @Override
    public boolean isRenderable(View view) {
        return view.getTemplateName().endsWith(this.getSuffix());
    }

    @Override
    public void render(View view, Locale locale, OutputStream output) throws IOException {
        try {
            Mustache template = this.factories.get(view.getClass()).compile(view.getTemplateName());
            Charset charset = view.getCharset().or(Charsets.UTF_8);
            try (OutputStreamWriter writer = new OutputStreamWriter(output, charset);){
                template.execute((Writer)writer, view);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Mustache template error: " + view.getTemplateName(), e);
        }
    }

    @Override
    public void configure(Map<String, String> options) {
    }

    @Override
    public String getSuffix() {
        return ".mustache";
    }
}

