/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Optional;
import java.nio.charset.Charset;

public abstract class View {
    private final String templateName;
    private final Charset charset;

    protected View(String templateName) {
        this(templateName, null);
    }

    protected View(String templateName, Charset charset) {
        this.templateName = this.resolveName(templateName);
        this.charset = charset;
    }

    @JsonIgnore
    public String getTemplateName() {
        return this.templateName;
    }

    @JsonIgnore
    public Optional<Charset> getCharset() {
        return Optional.fromNullable(this.charset);
    }

    private String resolveName(String templateName) {
        if (templateName.startsWith("/")) {
            return templateName;
        }
        String packagePath = this.getClass().getPackage().getName().replace('.', '/');
        return String.format("/%s/%s", packagePath, templateName);
    }
}

