/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.util.SizeUnit;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Size
implements Comparable<Size> {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)\\s*(\\S+)");
    private static final Map<String, SizeUnit> SUFFIXES = new ImmutableMap.Builder<String, SizeUnit>().put("B", SizeUnit.BYTES).put("byte", SizeUnit.BYTES).put("bytes", SizeUnit.BYTES).put("KB", SizeUnit.KILOBYTES).put("KiB", SizeUnit.KILOBYTES).put("kilobyte", SizeUnit.KILOBYTES).put("kilobytes", SizeUnit.KILOBYTES).put("MB", SizeUnit.MEGABYTES).put("MiB", SizeUnit.MEGABYTES).put("megabyte", SizeUnit.MEGABYTES).put("megabytes", SizeUnit.MEGABYTES).put("GB", SizeUnit.GIGABYTES).put("GiB", SizeUnit.GIGABYTES).put("gigabyte", SizeUnit.GIGABYTES).put("gigabytes", SizeUnit.GIGABYTES).put("TB", SizeUnit.TERABYTES).put("TiB", SizeUnit.TERABYTES).put("terabyte", SizeUnit.TERABYTES).put("terabytes", SizeUnit.TERABYTES).build();
    private final long count;
    private final SizeUnit unit;

    public static Size bytes(long count) {
        return new Size(count, SizeUnit.BYTES);
    }

    public static Size kilobytes(long count) {
        return new Size(count, SizeUnit.KILOBYTES);
    }

    public static Size megabytes(long count) {
        return new Size(count, SizeUnit.MEGABYTES);
    }

    public static Size gigabytes(long count) {
        return new Size(count, SizeUnit.GIGABYTES);
    }

    public static Size terabytes(long count) {
        return new Size(count, SizeUnit.TERABYTES);
    }

    @JsonCreator
    public static Size parse(String size) {
        Matcher matcher = SIZE_PATTERN.matcher(size);
        Preconditions.checkArgument(matcher.matches(), "Invalid size: " + size);
        long count = Long.parseLong(matcher.group(1));
        SizeUnit unit = SUFFIXES.get(matcher.group(2));
        if (unit == null) {
            throw new IllegalArgumentException("Invalid size: " + size + ". Wrong size unit");
        }
        return new Size(count, unit);
    }

    private Size(long count, SizeUnit unit) {
        this.count = count;
        this.unit = Preconditions.checkNotNull(unit);
    }

    public long getQuantity() {
        return this.count;
    }

    public SizeUnit getUnit() {
        return this.unit;
    }

    public long toBytes() {
        return SizeUnit.BYTES.convert(this.count, this.unit);
    }

    public long toKilobytes() {
        return SizeUnit.KILOBYTES.convert(this.count, this.unit);
    }

    public long toMegabytes() {
        return SizeUnit.MEGABYTES.convert(this.count, this.unit);
    }

    public long toGigabytes() {
        return SizeUnit.GIGABYTES.convert(this.count, this.unit);
    }

    public long toTerabytes() {
        return SizeUnit.TERABYTES.convert(this.count, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Size size = (Size)obj;
        return this.count == size.count && this.unit == size.unit;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + ' ' + units;
    }

    @Override
    public int compareTo(Size other) {
        if (this.unit == other.unit) {
            return Long.compare(this.count, other.count);
        }
        return Long.compare(this.toBytes(), other.toBytes());
    }
}

