/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.spdy;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.HttpsConnectorFactory;
import io.dropwizard.spdy.NonePushStrategyFactory;
import io.dropwizard.spdy.PushStrategyFactory;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="spdy3")
public class Spdy3ConnectorFactory
extends HttpsConnectorFactory {
    private static final String SPDY_3 = "spdy/3";
    private static final String HTTP_1_1 = "http/1.1";
    private static final String ALPN = "alpn";
    @Valid
    @NotNull
    private PushStrategyFactory pushStrategy = new NonePushStrategyFactory();

    @JsonProperty
    public PushStrategyFactory getPushStrategy() {
        return this.pushStrategy;
    }

    @JsonProperty
    public void setPushStrategy(PushStrategyFactory pushStrategy) {
        this.pushStrategy = pushStrategy;
    }

    @Override
    public Connector build(Server server, MetricRegistry metrics, String name, ThreadPool threadPool) {
        this.logSupportedParameters();
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig);
        SslContextFactory sslContextFactory = this.buildSslContextFactory();
        server.addBean(sslContextFactory);
        PushStrategy pushStrategy = this.pushStrategy.build();
        HTTPSPDYServerConnectionFactory spdyFactory = new HTTPSPDYServerConnectionFactory(3, httpConfig, pushStrategy);
        ALPNServerConnectionFactory negotiatingFactory = new ALPNServerConnectionFactory(new String[]{SPDY_3, HTTP_1_1});
        negotiatingFactory.setDefaultProtocol(HTTP_1_1);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, ALPN);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        return this.buildConnector(server, scheduler, bufferPool, name, threadPool, new InstrumentedConnectionFactory(sslConnectionFactory, metrics.timer(this.httpConnections())), negotiatingFactory, spdyFactory, httpConnectionFactory);
    }
}

