/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.spdy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.spdy.PushStrategyFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.spdy.server.http.ReferrerPushStrategy;

@JsonTypeName(value="referrer")
public class ReferrerPushStrategyFactory
implements PushStrategyFactory {
    private List<String> pushableOriginPatterns;
    @Min(value=1L)
    private int maxAssociatedResources = 32;
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration referrerPushPeriod = Duration.seconds(5L);
    private List<String> pushableFilenamePatterns;
    private List<String> pushableContentTypes;
    private List<String> nonPushableUserAgentPatterns;

    @JsonProperty
    public List<String> getPushableOriginPatterns() {
        return this.pushableOriginPatterns;
    }

    @JsonProperty
    public void setPushableOriginPatterns(List<String> origins) {
        this.pushableOriginPatterns = origins;
    }

    @JsonProperty
    public int getMaxAssociatedResources() {
        return this.maxAssociatedResources;
    }

    @JsonProperty
    public void setMaxAssociatedResources(int maxAssociatedResources) {
        this.maxAssociatedResources = maxAssociatedResources;
    }

    @JsonProperty
    public Duration getReferrerPushPeriod() {
        return this.referrerPushPeriod;
    }

    @JsonProperty
    public void setReferrerPushPeriod(Duration referrerPushPeriod) {
        this.referrerPushPeriod = referrerPushPeriod;
    }

    @JsonProperty
    public List<String> getPushableFilenamePatterns() {
        return this.pushableFilenamePatterns;
    }

    @JsonProperty
    public void setPushableFilenamePatterns(List<String> pushableFilenamePatterns) {
        this.pushableFilenamePatterns = pushableFilenamePatterns;
    }

    @JsonProperty
    public List<String> getPushableContentTypes() {
        return this.pushableContentTypes;
    }

    @JsonProperty
    public void setPushableContentTypes(List<String> pushableContentTypes) {
        this.pushableContentTypes = pushableContentTypes;
    }

    @JsonProperty
    public List<String> getNonPushableUserAgentPatterns() {
        return this.nonPushableUserAgentPatterns;
    }

    @JsonProperty
    public void setNonPushableUserAgentPatterns(List<String> nonPushableUserAgentPatterns) {
        this.nonPushableUserAgentPatterns = nonPushableUserAgentPatterns;
    }

    @Override
    public PushStrategy build() {
        ReferrerPushStrategy strategy = new ReferrerPushStrategy();
        if (this.pushableOriginPatterns != null) {
            strategy.setAllowedPushOrigins(this.pushableOriginPatterns);
        }
        if (this.pushableContentTypes != null) {
            strategy.setPushContentTypes(this.pushableContentTypes);
        }
        if (this.pushableFilenamePatterns != null) {
            strategy.setPushRegexps(this.pushableFilenamePatterns);
        }
        if (this.nonPushableUserAgentPatterns != null) {
            strategy.setUserAgentBlacklist(this.nonPushableUserAgentPatterns);
        }
        strategy.setMaxAssociatedResources(this.maxAssociatedResources);
        strategy.setReferrerPushPeriod((int)this.referrerPushPeriod.toMilliseconds());
        return strategy;
    }
}

