/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbMigrateCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private PrintStream outputStream = System.out;

    @VisibleForTesting
    void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public DbMigrateCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass) {
        super("migrate", "Apply all pending change sets.", strategy, configurationClass);
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument("-n", "--dry-run").action(Arguments.storeTrue()).dest("dry-run").setDefault(Boolean.FALSE).help("output the DDL to stdout, don't run it");
        subparser.addArgument("-c", "--count").type(Integer.class).dest("count").help("only apply the next N change sets");
        subparser.addArgument("-i", "--include").action(Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        String context = this.getContext(namespace);
        Integer count = namespace.getInt("count");
        boolean dryRun = MoreObjects.firstNonNull(namespace.getBoolean("dry-run"), false);
        if (count != null) {
            if (dryRun) {
                liquibase.update((int)count, context, (Writer)new OutputStreamWriter((OutputStream)this.outputStream, Charsets.UTF_8));
            } else {
                liquibase.update(count, context);
            }
        } else if (dryRun) {
            liquibase.update(context, (Writer)new OutputStreamWriter((OutputStream)this.outputStream, Charsets.UTF_8));
        } else {
            liquibase.update(context);
        }
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return Joiner.on(',').join(contexts);
    }
}

