/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.google.common.collect.Maps;
import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import io.dropwizard.migrations.DbCalculateChecksumCommand;
import io.dropwizard.migrations.DbClearChecksumsCommand;
import io.dropwizard.migrations.DbDropAllCommand;
import io.dropwizard.migrations.DbDumpCommand;
import io.dropwizard.migrations.DbFastForwardCommand;
import io.dropwizard.migrations.DbGenerateDocsCommand;
import io.dropwizard.migrations.DbLocksCommand;
import io.dropwizard.migrations.DbMigrateCommand;
import io.dropwizard.migrations.DbPrepareRollbackCommand;
import io.dropwizard.migrations.DbRollbackCommand;
import io.dropwizard.migrations.DbStatusCommand;
import io.dropwizard.migrations.DbTagCommand;
import io.dropwizard.migrations.DbTestCommand;
import java.util.SortedMap;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private static final String COMMAND_NAME_ATTR = "subcommand";
    private final SortedMap<String, AbstractLiquibaseCommand<T>> subcommands = Maps.newTreeMap();

    public DbCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass) {
        super("db", "Run database migration tasks", strategy, configurationClass);
        this.addSubcommand(new DbCalculateChecksumCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbClearChecksumsCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbDropAllCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbDumpCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbFastForwardCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbGenerateDocsCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbLocksCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbMigrateCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbPrepareRollbackCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbRollbackCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbStatusCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbTagCommand<T>(strategy, configurationClass));
        this.addSubcommand(new DbTestCommand<T>(strategy, configurationClass));
    }

    private void addSubcommand(AbstractLiquibaseCommand<T> subcommand) {
        this.subcommands.put(subcommand.getName(), subcommand);
    }

    @Override
    public void configure(Subparser subparser) {
        for (AbstractLiquibaseCommand<T> subcommand : this.subcommands.values()) {
            Subparser cmdParser = subparser.addSubparsers().addParser(subcommand.getName()).setDefault(COMMAND_NAME_ATTR, subcommand.getName()).description(subcommand.getDescription());
            subcommand.configure(cmdParser);
        }
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        AbstractLiquibaseCommand subcommand = (AbstractLiquibaseCommand)this.subcommands.get(namespace.getString(COMMAND_NAME_ATTR));
        subcommand.run(namespace, liquibase);
    }
}

