/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.metrics.ReporterFactory;
import io.dropwizard.metrics.ScheduledReporterManager;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsFactory.class);
    @Valid
    @NotNull
    private Duration frequency = Duration.minutes(1L);
    @Valid
    @NotNull
    private ImmutableList<ReporterFactory> reporters = ImmutableList.of();

    @JsonProperty
    public ImmutableList<ReporterFactory> getReporters() {
        return this.reporters;
    }

    @JsonProperty
    public void setReporters(ImmutableList<ReporterFactory> reporters) {
        this.reporters = reporters;
    }

    @JsonProperty
    public Duration getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public void setFrequency(Duration frequency) {
        this.frequency = frequency;
    }

    public void configure(LifecycleEnvironment environment, MetricRegistry registry) {
        for (ReporterFactory reporter : this.reporters) {
            try {
                ScheduledReporterManager manager = new ScheduledReporterManager(reporter.build(registry), reporter.getFrequency().or(this.getFrequency()));
                environment.manage(manager);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create reporter, metrics may not be properly reported.", e);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("frequency", this.frequency).add("reporters", this.reporters).toString();
    }
}

