/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.lifecycle.setup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.dropwizard.lifecycle.JettyManaged;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.lifecycle.setup.ExecutorServiceBuilder;
import io.dropwizard.lifecycle.setup.ScheduledExecutorServiceBuilder;
import java.util.List;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleEnvironment.class);
    private final List<LifeCycle> managedObjects = Lists.newArrayList();
    private final List<LifeCycle.Listener> lifecycleListeners = Lists.newArrayList();

    public List<LifeCycle> getManagedObjects() {
        return this.managedObjects;
    }

    public void manage(Managed managed) {
        this.managedObjects.add(new JettyManaged(Preconditions.checkNotNull(managed)));
    }

    public void manage(LifeCycle managed) {
        this.managedObjects.add(Preconditions.checkNotNull(managed));
    }

    public ExecutorServiceBuilder executorService(String nameFormat) {
        return new ExecutorServiceBuilder(this, nameFormat);
    }

    public ScheduledExecutorServiceBuilder scheduledExecutorService(String nameFormat) {
        return this.scheduledExecutorService(nameFormat, false);
    }

    public ScheduledExecutorServiceBuilder scheduledExecutorService(String nameFormat, boolean useDaemonThreads) {
        return new ScheduledExecutorServiceBuilder(this, nameFormat, useDaemonThreads);
    }

    public void addServerLifecycleListener(ServerLifecycleListener listener) {
        this.lifecycleListeners.add(new ServerListener(listener));
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void attach(ContainerLifeCycle container) {
        for (LifeCycle object : this.managedObjects) {
            container.addBean(object);
        }
        container.addLifeCycleListener(new AbstractLifeCycle.AbstractLifeCycleListener(){

            @Override
            public void lifeCycleStarting(LifeCycle event) {
                LOGGER.debug("managed objects = {}", (Object)LifecycleEnvironment.this.managedObjects);
            }
        });
        for (LifeCycle.Listener listener : this.lifecycleListeners) {
            container.addLifeCycleListener(listener);
        }
    }

    private static class ServerListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private final ServerLifecycleListener listener;

        private ServerListener(ServerLifecycleListener listener) {
            this.listener = listener;
        }

        @Override
        public void lifeCycleStarted(LifeCycle event) {
            if (event instanceof Server) {
                this.listener.serverStarted((Server)event);
            }
        }
    }
}

